/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.bukkitutil.block;

import ch.njol.skript.Skript;
import ch.njol.skript.bukkitutil.ItemUtils;
import ch.njol.skript.bukkitutil.block.BlockCompat;
import ch.njol.skript.bukkitutil.block.BlockSetter;
import ch.njol.skript.bukkitutil.block.BlockValues;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.FallingBlock;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

public class MagicBlockCompat
implements BlockCompat {
    private static final MethodHandle setRawDataMethod;
    private static final MethodHandle getBlockDataMethod;
    public static final MethodHandle setDataMethod;

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            MethodHandle mh = lookup.findVirtual(BlockState.class, "setRawData", MethodType.methodType(Void.TYPE, Byte.TYPE));
            assert (mh != null);
            setRawDataMethod = mh;
            mh = lookup.findVirtual(FallingBlock.class, "getBlockData", MethodType.methodType(Byte.TYPE));
            assert (mh != null);
            getBlockDataMethod = mh;
            mh = lookup.findVirtual(Block.class, "setData", MethodType.methodType(Void.TYPE, Byte.TYPE));
            assert (mh != null);
            setDataMethod = mh;
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    @Override
    public BlockValues getBlockValues(BlockState block) {
        return new MagicBlockValues(block);
    }

    @Override
    public BlockState fallingBlockToState(FallingBlock entity) {
        BlockState state = entity.getWorld().getBlockAt(0, 0, 0).getState();
        state.setType(entity.getMaterial());
        try {
            setRawDataMethod.invokeExact(state, getBlockDataMethod.invokeExact(entity));
        }
        catch (Throwable e) {
            Skript.exception(e, new String[0]);
        }
        return state;
    }

    @Override
    @Nullable
    public BlockValues createBlockValues(Material type, Map<String, String> states) {
        return null;
    }

    @Override
    public boolean isEmpty(Material type) {
        return type == Material.AIR;
    }

    @Override
    public boolean isLiquid(Material type) {
        return type == Material.WATER || type == Material.LAVA;
    }

    @Override
    @Nullable
    public BlockValues getBlockValues(ItemStack stack) {
        short data = (short)ItemUtils.getDamage(stack);
        if (data != 0) {
            return new MagicBlockValues(stack.getType(), data);
        }
        return null;
    }

    @Override
    public BlockSetter getSetter() {
        return new MagicBlockSetter();
    }

    private static class MagicBlockSetter
    implements BlockSetter {
        @Override
        public void setBlock(Block block, Material type, @Nullable BlockValues values, int flags) {
            block.setType(type);
            if (values != null) {
                MagicBlockValues ourValues = (MagicBlockValues)values;
                try {
                    setDataMethod.invokeExact(block, (byte)ourValues.data);
                }
                catch (Throwable e) {
                    Skript.exception(e, new String[0]);
                }
            }
        }
    }

    private class MagicBlockValues
    extends BlockValues {
        private Material id;
        short data;

        public MagicBlockValues(BlockState block) {
            this.id = block.getType();
            this.data = block.getRawData();
        }

        public MagicBlockValues(Material id, short data) {
            this.id = id;
            this.data = data;
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (!(other instanceof MagicBlockValues)) {
                return false;
            }
            MagicBlockValues magic = (MagicBlockValues)other;
            return this.id == magic.id && this.data == magic.data;
        }

        @Override
        public int hashCode() {
            return this.id.ordinal() << 8 | this.data & 0xFF;
        }
    }
}

