/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptUpdater;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.EnumParser;
import ch.njol.skript.config.Option;
import ch.njol.skript.config.OptionSection;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.function.Function;
import ch.njol.skript.localization.Language;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.log.Verbosity;
import ch.njol.skript.timings.SkriptTimings;
import ch.njol.skript.update.ReleaseChannel;
import ch.njol.skript.util.FileUtils;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.util.chat.ChatMessages;
import ch.njol.skript.util.chat.LinkParseMode;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Setter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.event.EventPriority;
import org.eclipse.jdt.annotation.Nullable;

public abstract class SkriptConfig {
    @Nullable
    static Config mainConfig;
    static Collection<Config> configs;
    static final Option<String> version;
    public static final Option<String> language;
    static final Option<Boolean> checkForNewVersion;
    static final Option<Timespan> updateCheckInterval;
    static final Option<Integer> updaterDownloadTries;
    static final Option<String> releaseChannel;
    @Deprecated
    static final Option<Boolean> automaticallyDownloadNewVersion;
    @Deprecated
    static final Option<Boolean> updateToPrereleases;
    public static final Option<Boolean> enableEffectCommands;
    public static final Option<String> effectCommandToken;
    public static final Option<Boolean> allowOpsToUseEffectCommands;
    public static final OptionSection databases;
    public static final Option<Boolean> usePlayerUUIDsInVariableNames;
    public static final Option<Boolean> enablePlayerVariableFix;
    private static final DateFormat shortDateFormat;
    private static final Option<DateFormat> dateFormat;
    static final Option<Verbosity> verbosity;
    public static final Option<EventPriority> defaultEventPriority;
    public static final Option<Boolean> logPlayerCommands;
    public static final Option<Integer> numberAccuracy;
    public static final Option<Integer> maxTargetBlockDistance;
    public static final Option<Boolean> caseSensitive;
    public static final Option<Boolean> allowFunctionsBeforeDefs;
    public static final Option<Boolean> disableVariableConflictWarnings;
    public static final Option<Boolean> disableObjectCannotBeSavedWarnings;
    public static final Option<Boolean> disableMissingAndOrWarnings;
    public static final Option<Boolean> disableVariableStartingWithExpressionWarnings;
    @Deprecated
    public static final Option<Boolean> enableScriptCaching;
    public static final Option<Boolean> keepConfigsLoaded;
    public static final Option<Boolean> addonSafetyChecks;
    public static final Option<Boolean> apiSoftExceptions;
    public static final Option<Boolean> enableTimings;
    public static final Option<String> parseLinks;
    public static final Option<Boolean> caseInsensitiveVariables;
    public static final Option<Boolean> colorResetCodes;
    public static final Option<Boolean> asyncLoaderEnabled;
    public static final Option<Boolean> allowUnsafePlatforms;
    public static final Option<Boolean> keepLastUsageDates;
    public static final Option<Boolean> loadDefaultAliases;
    public static final Option<Boolean> executeFunctionsWithMissingParams;

    static {
        configs = new ArrayList<Config>();
        version = new Option<String>("version", Skript.getVersion().toString()).optional(true);
        language = new Option<String>("language", "english").optional(true).setter(new Setter<String>(){

            @Override
            public void set(String s) {
                if (!Language.load(s)) {
                    Skript.error("No language file found for '" + s + "'!");
                }
            }
        });
        checkForNewVersion = new Option<Boolean>("check for new version", false).setter(new Setter<Boolean>(){

            @Override
            public void set(Boolean t) {
                SkriptUpdater updater = Skript.getInstance().getUpdater();
                if (updater != null) {
                    updater.setEnabled(t);
                }
            }
        });
        updateCheckInterval = new Option<Timespan>("update check interval", new Timespan(43200000L)).setter(new Setter<Timespan>(){

            @Override
            public void set(Timespan t) {
                SkriptUpdater updater = Skript.getInstance().getUpdater();
                if (updater != null) {
                    updater.setCheckFrequency(t.getTicks_i());
                }
            }
        });
        updaterDownloadTries = new Option<Integer>("updater download tries", 7).optional(true);
        releaseChannel = new Option<String>("release channel", "none").setter(new Setter<String>(){

            @Override
            public void set(String t) {
                ReleaseChannel channel;
                if (t.equals("alpha")) {
                    channel = new ReleaseChannel(name -> true, t);
                } else if (t.equals("beta")) {
                    channel = new ReleaseChannel(name -> !name.contains("alpha"), t);
                } else if (t.equals("stable")) {
                    channel = new ReleaseChannel(name -> !name.contains("alpha") && !name.contains("beta"), t);
                } else if (t.equals("none")) {
                    channel = new ReleaseChannel(name -> false, t);
                } else {
                    channel = new ReleaseChannel(name -> false, t);
                    Skript.error("Unknown release channel '" + t + "'.");
                }
                SkriptUpdater updater = Skript.getInstance().getUpdater();
                if (updater != null) {
                    if (updater.getCurrentRelease().flavor.contains("spigot") && !t.equals("stable")) {
                        Skript.error("Only stable Skript versions are uploaded to Spigot resources.");
                    }
                    updater.setReleaseChannel(channel);
                }
            }
        });
        automaticallyDownloadNewVersion = new Option<Boolean>("automatically download new version", false).optional(true);
        updateToPrereleases = new Option<Boolean>("update to pre-releases", true).optional(true);
        enableEffectCommands = new Option<Boolean>("enable effect commands", false);
        effectCommandToken = new Option<String>("effect command token", "!");
        allowOpsToUseEffectCommands = new Option<Boolean>("allow ops to use effect commands", false);
        databases = new OptionSection("databases");
        usePlayerUUIDsInVariableNames = new Option<Boolean>("use player UUIDs in variable names", false);
        enablePlayerVariableFix = new Option<Boolean>("player variable fix", true);
        shortDateFormat = DateFormat.getDateTimeInstance(3, 3);
        dateFormat = new Option<DateFormat>("date format", shortDateFormat, new Converter<String, DateFormat>(){

            @Override
            @Nullable
            public DateFormat convert(String s) {
                block3: {
                    try {
                        if (!s.equalsIgnoreCase("default")) break block3;
                        return null;
                    }
                    catch (IllegalArgumentException e) {
                        Skript.error("'" + s + "' is not a valid date format. Please refer to http://docs.oracle.com/javase/6/docs/api/java/text/SimpleDateFormat.html for instructions on the format.");
                        return null;
                    }
                }
                return new SimpleDateFormat(s);
            }
        });
        verbosity = new Option<Verbosity>("verbosity", Verbosity.NORMAL, new EnumParser<Verbosity>(Verbosity.class, "verbosity")).setter(new Setter<Verbosity>(){

            @Override
            public void set(Verbosity v) {
                SkriptLogger.setVerbosity(v);
            }
        });
        defaultEventPriority = new Option<EventPriority>("plugin priority", EventPriority.NORMAL, new Converter<String, EventPriority>(){

            @Override
            @Nullable
            public EventPriority convert(String s) {
                try {
                    return EventPriority.valueOf((String)s.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    Skript.error("The plugin priority has to be one of lowest, low, normal, high, or highest.");
                    return null;
                }
            }
        });
        logPlayerCommands = new Option<Boolean>("log player commands", false);
        numberAccuracy = new Option<Integer>("number accuracy", 2);
        maxTargetBlockDistance = new Option<Integer>("maximum target block distance", 100);
        caseSensitive = new Option<Boolean>("case sensitive", false);
        allowFunctionsBeforeDefs = new Option<Boolean>("allow function calls before definations", false).optional(true);
        disableVariableConflictWarnings = new Option<Boolean>("disable variable conflict warnings", false);
        disableObjectCannotBeSavedWarnings = new Option<Boolean>("disable variable will not be saved warnings", false);
        disableMissingAndOrWarnings = new Option<Boolean>("disable variable missing and/or warnings", false);
        disableVariableStartingWithExpressionWarnings = new Option<Boolean>("disable starting a variable's name with an expression warnings", false).setter(new Setter<Boolean>(){

            @Override
            public void set(Boolean t) {
                VariableString.disableVariableStartingWithExpressionWarnings = t;
            }
        });
        enableScriptCaching = new Option<Boolean>("enable script caching", false).optional(true);
        keepConfigsLoaded = new Option<Boolean>("keep configs loaded", false).optional(true);
        addonSafetyChecks = new Option<Boolean>("addon safety checks", false).optional(true);
        apiSoftExceptions = new Option<Boolean>("soft api exceptions", false);
        enableTimings = new Option<Boolean>("enable timings", false).setter(new Setter<Boolean>(){

            @Override
            public void set(Boolean t) {
                if (Skript.classExists("co.aikar.timings.Timings")) {
                    if (t.booleanValue()) {
                        Skript.info("Timings support enabled!");
                    }
                    SkriptTimings.setEnabled(t);
                } else {
                    if (t.booleanValue()) {
                        Skript.warning("Timings cannot be enabled! You are running Bukkit/Spigot, but Paper is required.");
                    }
                    SkriptTimings.setEnabled(false);
                }
            }
        });
        parseLinks = new Option<String>("parse links in chat messages", "disabled").setter(new Setter<String>(){

            @Override
            public void set(String t) {
                try {
                    switch (t) {
                        case "false": 
                        case "disabled": {
                            ChatMessages.linkParseMode = LinkParseMode.DISABLED;
                            break;
                        }
                        case "true": 
                        case "lenient": {
                            ChatMessages.linkParseMode = LinkParseMode.LENIENT;
                            break;
                        }
                        case "strict": {
                            ChatMessages.linkParseMode = LinkParseMode.STRICT;
                            break;
                        }
                        default: {
                            ChatMessages.linkParseMode = LinkParseMode.DISABLED;
                            Skript.warning("Unknown link parse mode: " + t + ", please use disabled, strict or lenient");
                            break;
                        }
                    }
                }
                catch (Error error) {
                    // empty catch block
                }
            }
        });
        caseInsensitiveVariables = new Option<Boolean>("case-insensitive variables", true).setter(new Setter<Boolean>(){

            @Override
            public void set(Boolean t) {
                Variables.caseInsensitiveVariables = t;
            }
        }).optional(true);
        colorResetCodes = new Option<Boolean>("color codes reset formatting", true).setter(new Setter<Boolean>(){

            @Override
            public void set(Boolean t) {
                try {
                    ChatMessages.colorResetCodes = t;
                }
                catch (Error error) {
                    // empty catch block
                }
            }
        });
        asyncLoaderEnabled = new Option<Boolean>("asynchronous script loading", false).setter(new Setter<Boolean>(){

            @Override
            public void set(Boolean t) {
                ScriptLoader.loadAsync = t;
            }
        }).optional(true);
        allowUnsafePlatforms = new Option<Boolean>("allow unsafe platforms", false).optional(true);
        keepLastUsageDates = new Option<Boolean>("keep command last usage dates", false).optional(true);
        loadDefaultAliases = new Option<Boolean>("load default aliases", true).optional(true);
        executeFunctionsWithMissingParams = new Option<Boolean>("execute functions with missing parameters", true).optional(true).setter(new Setter<Boolean>(){

            @Override
            public void set(Boolean t) {
                Function.executeWithNulls = t;
            }
        });
    }

    private SkriptConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDate(long timestamp) {
        DateFormat f;
        DateFormat dateFormat = f = SkriptConfig.dateFormat.value();
        synchronized (dateFormat) {
            return f.format(timestamp);
        }
    }

    @Nullable
    public static Config getConfig() {
        return mainConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean load() {
        try {
            Config mc;
            File oldConfigFile = new File(Skript.getInstance().getDataFolder(), "config.cfg");
            File configFile = new File(Skript.getInstance().getDataFolder(), "config.sk");
            if (oldConfigFile.exists()) {
                if (!configFile.exists()) {
                    oldConfigFile.renameTo(configFile);
                    Skript.info("[1.3] Renamed your 'config.cfg' to 'config.sk' to match the new format");
                } else {
                    Skript.error("Found both a new and an old config, ignoring the old one");
                }
            }
            if (!configFile.exists()) {
                Skript.error("Config file 'config.sk' does not exist!");
                return false;
            }
            if (!configFile.canRead()) {
                Skript.error("Config file 'config.sk' cannot be read!");
                return false;
            }
            try {
                mc = new Config(configFile, false, false, ":");
            }
            catch (IOException e) {
                Skript.error("Could not load the main config: " + e.getLocalizedMessage());
                return false;
            }
            mainConfig = mc;
            if (!Skript.getVersion().toString().equals(mc.get(SkriptConfig.version.key))) {
                try {
                    InputStream in = Skript.getInstance().getResource("config.sk");
                    if (in == null) {
                        Skript.error("Your config is outdated, but Skript couldn't find the newest config in its jar. Please download Skript again from dev.bukkit.org.");
                        return false;
                    }
                    Config newConfig = new Config(in, "Skript.jar/config.sk", false, false, ":");
                    in.close();
                    boolean forceUpdate = false;
                    if (mc.getMainNode().get("database") != null) {
                        forceUpdate = true;
                        try {
                            SectionNode oldDB = (SectionNode)mc.getMainNode().get("database");
                            assert (oldDB != null);
                            SectionNode newDBs = (SectionNode)newConfig.getMainNode().get(SkriptConfig.databases.key);
                            assert (newDBs != null);
                            SectionNode newDB = (SectionNode)newDBs.get("database 1");
                            assert (newDB != null);
                            newDB.setValues(oldDB, new String[0]);
                            String file = newDB.getValue("file");
                            assert (file != null);
                            if (!file.endsWith(".db")) {
                                newDB.set("file", String.valueOf(file) + ".db");
                            }
                            SectionNode def = (SectionNode)newDBs.get("default");
                            assert (def != null);
                            def.set("backup interval", mc.get("variables backup interval"));
                        }
                        catch (Exception e) {
                            Skript.error("An error occurred while trying to update the config's database section.");
                            Skript.error("You'll have to update the config yourself:");
                            Skript.error("Open the new config.sk as well as the created backup, and move the 'database' section from the backup to the start of the 'databases' section");
                            Skript.error("of the new config (i.e. the line 'databases:' should be directly above 'database:'), and add a tab in front of every line that you just copied.");
                            return false;
                        }
                    }
                    if (newConfig.setValues(mc, SkriptConfig.version.key, SkriptConfig.databases.key) || forceUpdate) {
                        File bu = FileUtils.backup(configFile);
                        newConfig.getMainNode().set(SkriptConfig.version.key, Skript.getVersion().toString());
                        if (mc.getMainNode().get(SkriptConfig.databases.key) != null) {
                            newConfig.getMainNode().set(SkriptConfig.databases.key, mc.getMainNode().get(SkriptConfig.databases.key));
                        }
                        mc = mainConfig = newConfig;
                        mc.save(configFile);
                        Skript.info("Your configuration has been updated to the latest version. A backup of your old config file has been created as " + bu.getName());
                    } else {
                        mc.getMainNode().set(SkriptConfig.version.key, Skript.getVersion().toString());
                        mc.save(configFile);
                    }
                }
                catch (IOException e) {
                    Skript.error("Could not load the new config from the jar file: " + e.getLocalizedMessage());
                }
            }
            mc.load(SkriptConfig.class);
            return true;
        }
        catch (RuntimeException e) {
            Skript.exception((Throwable)e, "An error occurred while loading the config");
            return false;
        }
    }
}

