/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.localization.Adjective;
import ch.njol.skript.localization.Language;
import ch.njol.yggdrasil.YggdrasilSerializable;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.eclipse.jdt.annotation.Nullable;

public enum Color implements YggdrasilSerializable
{
    BLACK(DyeColor.BLACK, ChatColor.BLACK),
    DARK_GREY(DyeColor.GRAY, ChatColor.DARK_GRAY),
    LIGHT_GREY(DyeColor.getByColor((org.bukkit.Color)org.bukkit.Color.fromRGB((int)0x9D9D97)), ChatColor.GRAY),
    WHITE(DyeColor.WHITE, ChatColor.WHITE),
    DARK_BLUE(DyeColor.BLUE, ChatColor.DARK_BLUE),
    BROWN(DyeColor.BROWN, ChatColor.BLUE),
    DARK_CYAN(DyeColor.CYAN, ChatColor.DARK_AQUA),
    LIGHT_CYAN(DyeColor.LIGHT_BLUE, ChatColor.AQUA),
    DARK_GREEN(DyeColor.GREEN, ChatColor.DARK_GREEN),
    LIGHT_GREEN(DyeColor.LIME, ChatColor.GREEN),
    YELLOW(DyeColor.YELLOW, ChatColor.YELLOW),
    ORANGE(DyeColor.ORANGE, ChatColor.GOLD),
    DARK_RED(DyeColor.RED, ChatColor.DARK_RED),
    LIGHT_RED(DyeColor.PINK, ChatColor.RED),
    DARK_PURPLE(DyeColor.PURPLE, ChatColor.DARK_PURPLE),
    LIGHT_PURPLE(DyeColor.MAGENTA, ChatColor.LIGHT_PURPLE);

    public static final String LANGUAGE_NODE = "colors";
    private DyeColor wool;
    private ChatColor chat;
    @Nullable
    private Adjective adjective;
    private static final Map<DyeColor, Color> BY_WOOL;
    static final Map<String, Color> BY_NAME;
    static final Map<String, Color> BY_ENGLISH_NAME;

    static {
        BY_WOOL = new HashMap<DyeColor, Color>();
        Color[] colorArray = Color.values();
        int n = colorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Color c = colorArray[n2];
            BY_WOOL.put(c.getWoolColor(), c);
            ++n2;
        }
        BY_NAME = new HashMap<String, Color>();
        BY_ENGLISH_NAME = new HashMap<String, Color>();
        Language.addListener(() -> {
            boolean english = BY_ENGLISH_NAME.isEmpty();
            BY_NAME.clear();
            Color[] colorArray = Color.values();
            int n = colorArray.length;
            int n2 = 0;
            while (n2 < n) {
                String[] names;
                Color c = colorArray[n2];
                String[] stringArray = names = Language.getList("colors." + c.name() + ".names");
                int n3 = names.length;
                int n4 = 0;
                while (n4 < n3) {
                    String name = stringArray[n4];
                    BY_NAME.put(name.toLowerCase(), c);
                    if (english) {
                        BY_ENGLISH_NAME.put(name.toLowerCase(), c);
                    }
                    ++n4;
                }
                c.setAdjective(new Adjective("colors." + c.name() + ".adjective"));
                ++n2;
            }
        });
    }

    private Color(DyeColor wool, ChatColor chat) {
        this.wool = wool;
        this.chat = chat;
    }

    public DyeColor getWoolColor() {
        return this.wool;
    }

    public String getChat() {
        return this.chat.toString();
    }

    public ChatColor asChatColor() {
        return this.chat;
    }

    public final org.bukkit.Color getBukkitColor() {
        return this.wool.getColor();
    }

    @Nullable
    public Adjective getAdjective() {
        return this.adjective;
    }

    public void setAdjective(Adjective adjective) {
        this.adjective = adjective;
    }

    @Nullable
    public static Color byName(String name) {
        return BY_NAME.get(name.toLowerCase());
    }

    @Nullable
    public static Color byEnglishName(String name) {
        return BY_ENGLISH_NAME.get(name.toLowerCase());
    }

    public static Color byWoolColor(DyeColor color) {
        return BY_WOOL.get(color);
    }

    public String toString() {
        Adjective a = this.adjective;
        return a == null ? this.name() : a.toString(-1, 0);
    }
}

