/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Subtext")
@Description(value={"Extracts part of a text. You can either get the first &lt;x&gt; characters, the last &lt;x&gt; characters, or the characters between indices &lt;x&gt; and &lt;y&gt;. The indices &lt;x&gt; and &lt;y&gt; should be between 1 and the <a href='#ExprLength'>length</a> of the text (other values will be fit into this range)."})
@Examples(value={"set {_s} to the first 5 characters of the text argument", "message \"%subtext of {_s} from characters 2 to (the length of {_s} - 1)%\" # removes the first and last character from {_s} and sends it to the player or console"})
@Since(value="2.1")
public class ExprSubstring
extends SimpleExpression<String> {
    private Expression<String> string;
    @Nullable
    private Expression<Number> start;
    @Nullable
    private Expression<Number> end;

    static {
        Skript.registerExpression(ExprSubstring.class, String.class, ExpressionType.COMBINED, "[the] (part|sub[ ](text|string)) of %strings% (between|from) (ind(ex|ices)|character[s]|) %number% (and|to) (index|character|) %number%", "[the] (1\u00a6first|2\u00a6last) [%-number%] character[s] of %strings%", "[the] %number% (1\u00a6first|2\u00a6last) characters of %strings%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.string = exprs[parseResult.mark == 0 ? 0 : 1];
        Expression<Number> expression = parseResult.mark == 1 ? null : (exprs[parseResult.mark == 0 ? 1 : 0] == null ? new SimpleLiteral<Integer>(1, false) : (this.start = exprs[parseResult.mark == 0 ? 1 : 0]));
        Expression<Number> expression2 = parseResult.mark == 2 ? null : (exprs[parseResult.mark == 0 ? 2 : 0] == null ? new SimpleLiteral<Integer>(1, false) : (this.end = exprs[parseResult.mark == 0 ? 2 : 0]));
        assert (this.end != null || this.start != null);
        return true;
    }

    @Nullable
    protected String[] get(Event e) {
        int i2;
        int i1;
        Integer d2;
        String s = this.string.getSingle(e);
        if (s == null) {
            return new String[0];
        }
        Number d1 = this.start != null ? (Number)this.start.getSingle(e) : (Number)1;
        Number number = d2 = this.end != null ? (Number)this.end.getSingle(e) : (Number)s.length();
        if (d1 == null || d2 == null) {
            return new String[0];
        }
        if (this.end == null) {
            d1 = (double)s.length() - ((Number)d1).doubleValue() + 1.0;
        }
        if ((i1 = Math.max(0, (int)Math.round(((Number)d1).doubleValue()) - 1)) >= (i2 = Math.min((int)Math.round(((Number)d2).doubleValue()), s.length()))) {
            return new String[0];
        }
        return new String[]{s.substring(i1, i2)};
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (this.start == null) {
            assert (this.end != null);
            return "the first " + this.end.toString(e, debug) + " characters of " + this.string.toString(e, debug);
        }
        if (this.end == null) {
            assert (this.start != null);
            return "the last " + this.start.toString(e, debug) + " characters of " + this.string.toString(e, debug);
        }
        return "the substring of " + this.string.toString(e, debug) + " from index " + this.start.toString(e, debug) + " to " + this.end.toString(e, debug);
    }
}

