/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Amount of Items")
@Description(value={"Counts how many of a particular <a href='../classes.html#itemtype'>item type</a> are in a given inventory."})
@Examples(value={"message \"You have %number of ores in the player's inventory% ores in your inventory.\""})
@Since(value="2.0")
public class ExprAmountOfItems
extends SimpleExpression<Integer> {
    private Expression<ItemType> items;
    private Expression<Inventory> invis;

    static {
        Skript.registerExpression(ExprAmountOfItems.class, Integer.class, ExpressionType.PROPERTY, "[the] (amount|number) of %itemtypes% (in|of) %inventories%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.items = exprs[0];
        this.invis = exprs[1];
        return true;
    }

    protected Integer[] get(Event e) {
        int r = 0;
        ItemType[] types = this.items.getArray(e);
        Inventory[] inventoryArray = this.invis.getArray(e);
        int n = inventoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Inventory invi = inventoryArray[n2];
            ItemStack[] itemStackArray = invi.getContents();
            int n3 = itemStackArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ItemStack i = itemStackArray[n4];
                ItemType[] itemTypeArray = types;
                int n5 = types.length;
                int n6 = 0;
                while (n6 < n5) {
                    ItemType t = itemTypeArray[n6];
                    if (t.isOfType(i)) {
                        r += i == null ? 1 : i.getAmount();
                        break;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return new Integer[]{r};
    }

    public Integer[] getAll(Event e) {
        int r = 0;
        ItemType[] types = this.items.getAll(e);
        Inventory[] inventoryArray = this.invis.getAll(e);
        int n = inventoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Inventory invi = inventoryArray[n2];
            ItemStack[] itemStackArray = invi.getContents();
            int n3 = itemStackArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ItemStack i = itemStackArray[n4];
                ItemType[] itemTypeArray = types;
                int n5 = types.length;
                int n6 = 0;
                while (n6 < n5) {
                    ItemType t = itemTypeArray[n6];
                    if (t.isOfType(i)) {
                        r += i == null ? 1 : i.getAmount();
                        break;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return new Integer[]{r};
    }

    @Override
    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "number of " + this.items + " in " + this.invis;
    }
}

