/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SyntaxElementInfo;
import java.util.Locale;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.eclipse.jdt.annotation.Nullable;

public final class SkriptEventInfo<E extends SkriptEvent>
extends SyntaxElementInfo<E> {
    public Class<? extends Event>[] events;
    public final String name;
    private final String id;
    @Nullable
    private String[] description;
    @Nullable
    private String[] examples;
    @Nullable
    private String since;
    @Nullable
    private String documentationID;
    @Nullable
    private String[] requiredPlugins;
    public static final String[] NO_DOC = new String[0];

    public SkriptEventInfo(String name, String[] patterns, Class<E> c, String originClassPath, Class<? extends Event>[] events) {
        super(patterns, c, originClassPath);
        assert (name != null);
        assert (patterns != null && patterns.length > 0);
        assert (c != null);
        assert (originClassPath != null);
        assert (events != null && events.length > 0);
        int i = 0;
        while (i < events.length) {
            int j = i + 1;
            while (j < events.length) {
                if ((events[i].isAssignableFrom(events[j]) || events[j].isAssignableFrom(events[i])) && !events[i].equals(PlayerInteractAtEntityEvent.class) && !events[j].equals(PlayerInteractAtEntityEvent.class)) {
                    throw new SkriptAPIException("The event " + name + " (" + c.getName() + ") registers with super/subclasses " + events[i].getName() + " and " + events[j].getName());
                }
                ++j;
            }
            ++i;
        }
        this.events = events;
        this.name = name.startsWith("*") ? (name = name.substring(1)) : "On " + name;
        this.id = name.toLowerCase(Locale.ENGLISH).replaceAll("[#'\"<>/&]", "").replaceAll("\\s+", "_");
    }

    public SkriptEventInfo<E> description(String ... description) {
        assert (this.description == null);
        this.description = description;
        return this;
    }

    public SkriptEventInfo<E> examples(String ... examples) {
        assert (this.examples == null);
        this.examples = examples;
        return this;
    }

    public SkriptEventInfo<E> since(String since) {
        assert (this.since == null);
        this.since = since;
        return this;
    }

    public SkriptEventInfo<E> documentationID(String id) {
        assert (this.documentationID == null);
        this.documentationID = id;
        return this;
    }

    public SkriptEventInfo<E> requiredPlugins(String ... pluginNames) {
        assert (this.requiredPlugins == null);
        this.requiredPlugins = pluginNames;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String[] getDescription() {
        return this.description;
    }

    @Nullable
    public String[] getExamples() {
        return this.examples;
    }

    @Nullable
    public String getSince() {
        return this.since;
    }

    @Nullable
    public String[] getRequiredPlugins() {
        return this.requiredPlugins;
    }

    @Nullable
    public String getDocumentationID() {
        return this.documentationID;
    }
}

