/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.VectorMath;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Spherical shape")
@Description(value={"Forms a 'spherical shaped' vector using yaw and pitch to manipulate the current point."})
@Examples(value={"loop 360 times:", "\tset {_v} to spherical vector radius 1, yaw loop-value, pitch loop-value", "set {_v} to spherical vector radius 1, yaw 45, pitch 90"})
@Since(value="2.2-dev28")
public class ExprVectorSpherical
extends SimpleExpression<Vector> {
    private Expression<Number> radius;
    private Expression<Number> yaw;
    private Expression<Number> pitch;

    static {
        Skript.registerExpression(ExprVectorSpherical.class, Vector.class, ExpressionType.SIMPLE, "[new] spherical vector [(from|with)] [radius] %number%, [yaw] %number%(,| and) [pitch] %number%");
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public String toString(@Nullable Event event, boolean b) {
        return "spherical vector with radius " + this.radius.toString() + ", yaw " + this.yaw.toString() + ", pitch" + this.pitch.toString();
    }

    @Override
    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    @Override
    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.radius = expressions[0];
        this.yaw = expressions[1];
        this.pitch = expressions[2];
        return true;
    }

    protected Vector[] get(Event event) {
        Number r = this.radius.getSingle(event);
        Number y = this.yaw.getSingle(event);
        Number p = this.pitch.getSingle(event);
        if (r == null || y == null || p == null) {
            return null;
        }
        return new Vector[]{VectorMath.fromSphericalCoordinates(r.doubleValue(), VectorMath.fromSkriptYaw(y.floatValue()), p.floatValue() + 90.0f)};
    }
}

