/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Kleenean;
import java.lang.reflect.Array;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Attacked")
@Description(value={"The victim of a damage event, e.g. when a player attacks a zombie this expression represents the zombie."})
@Examples(value={"on damage:", "\tvictim is a creeper", "\tdamage the attacked by 1 heart"})
@Since(value="1.3")
@Events(value={"damage", "death"})
public class ExprAttacked
extends SimpleExpression<Entity> {
    private EntityData<?> type;

    static {
        Skript.registerExpression(ExprAttacked.class, Entity.class, ExpressionType.SIMPLE, "[the] (attacked|damaged|victim) [<(.+)>]");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        String type;
        if (!ScriptLoader.isCurrentEvent(EntityDamageEvent.class, EntityDeathEvent.class)) {
            Skript.error("The expression 'victim' can only be used in a damage or death event", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        String string = type = parser.regexes.size() == 0 ? null : parser.regexes.get(0).group();
        if (type == null) {
            this.type = EntityData.fromClass(Entity.class);
        } else {
            EntityData<?> t = EntityData.parse(type);
            if (t == null) {
                Skript.error("'" + type + "' is not an entity type", ErrorQuality.NOT_AN_EXPRESSION);
                return false;
            }
            this.type = t;
        }
        return true;
    }

    @Nullable
    protected Entity[] get(Event e) {
        Entity[] one = (Entity[])Array.newInstance(this.type.getType(), 1);
        Entity entity = ((EntityEvent)e).getEntity();
        if (this.type.isInstance(entity)) {
            one[0] = entity;
            return one;
        }
        return null;
    }

    @Override
    public Class<? extends Entity> getReturnType() {
        return this.type.getType();
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (e == null) {
            return "the attacked " + this.type;
        }
        return Classes.getDebugMessage(this.getSingle(e));
    }

    @Override
    public boolean isSingle() {
        return true;
    }
}

