/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Title - Send")
@Description(value={"Sends a title/subtitle to the given player(s) with optional fadein/stay/fadeout times for Minecraft versions 1.11 and above.", "Note: if no input is given for the title/subtitle or the times,it will keep the ones from the last title sent, use the <a href='effects.html#EffResetTitle'>reset title</a> effect to restore the default values."})
@Examples(value={"send title \"Competition Started\" with subtitle \"Have fun, Stay safe!\" to player for 5 seconds", "send title \"Hi %player%\" to player", "send title \"Loot Drop\" with subtitle \"starts in 3 minutes\" to all players", "send title \"Hello %player%!\" with subtitle \"Welcome to our server\" to player for 5 seconds with fadein 1 second and fade out 1 second", "send subtitle \"Party!\" to all players"})
@Since(value="2.3")
public class EffSendTitle
extends Effect {
    private static final boolean TIME_SUPPORTED = Skript.methodExists(Player.class, "sendTitle", String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    @Nullable
    private Expression<String> title;
    @Nullable
    private Expression<String> subtitle;
    private Expression<Player> recipients;
    @Nullable
    private Expression<Timespan> fadeIn;
    @Nullable
    private Expression<Timespan> stay;
    @Nullable
    private Expression<Timespan> fadeOut;

    static {
        if (TIME_SUPPORTED) {
            Skript.registerEffect(EffSendTitle.class, "send title %string% [with subtitle %-string%] [to %players%] [for %-timespan%] [with fade[(-| )]in %-timespan%] [(and|with) fade[(-| )]out %-timespan%]", "send subtitle %string% [to %players%] [for %-timespan%] [with fade[(-| )]in %-timespan%] [(and|with) fade[(-| )]out %-timespan%]");
        } else {
            Skript.registerEffect(EffSendTitle.class, "send title %string% [with subtitle %-string%] [to %players%]", "send subtitle %string% [to %players%]");
        }
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.title = matchedPattern == 0 ? exprs[0] : null;
        this.subtitle = exprs[1 - matchedPattern];
        this.recipients = exprs[2 - matchedPattern];
        if (TIME_SUPPORTED) {
            this.stay = exprs[3 - matchedPattern];
            this.fadeIn = exprs[4 - matchedPattern];
            this.fadeOut = exprs[5 - matchedPattern];
        }
        return true;
    }

    @Override
    protected void execute(Event e) {
        String sub;
        String title = this.title != null ? this.title.getSingle(e) : "";
        String string = sub = this.subtitle != null ? this.subtitle.getSingle(e) : null;
        if (TIME_SUPPORTED) {
            int in = this.fadeIn != null ? (int)this.fadeIn.getSingle(e).getTicks_i() : -1;
            int stay = this.stay != null ? (int)this.stay.getSingle(e).getTicks_i() : -1;
            int out = this.fadeOut != null ? (int)this.fadeOut.getSingle(e).getTicks_i() : -1;
            Player[] playerArray = this.recipients.getArray(e);
            int n = playerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Player p = playerArray[n2];
                p.sendTitle(title, sub, in, stay, out);
                ++n2;
            }
        } else {
            Player[] playerArray = this.recipients.getArray(e);
            int n = playerArray.length;
            int n3 = 0;
            while (n3 < n) {
                Player p = playerArray[n3];
                p.sendTitle(title, sub);
                ++n3;
            }
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        String out;
        String title = this.title != null ? this.title.toString(e, debug) : "";
        String sub = this.subtitle != null ? this.subtitle.toString(e, debug) : "";
        String in = this.fadeIn != null ? this.fadeIn.toString(e, debug) : "";
        String stay = this.stay != null ? this.stay.toString(e, debug) : "";
        String string = out = this.fadeOut != null ? this.fadeOut.toString(e, debug) : "";
        return String.valueOf(title == null ? "send subtitle " + sub : ("send title " + title + sub == "" ? "" : " with subtitle " + sub)) + " to " + this.recipients.toString(e, debug) + (TIME_SUPPORTED ? " for " + stay + " with fade in " + in + " and fade out" + out : "");
    }
}

