/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.Date;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Ban")
@Description(value={"Bans/unbans a player or an IP address.", "Starting with Skript 2.1.1 and Bukkit 1.7.2 R0.4, one can also ban players with a reason."})
@Examples(value={"unban player", "ban \"127.0.0.1\"", "IP-ban the player because \"he is an idiot\""})
@Since(value="1.4, 2.1.1 (ban reason)")
public class EffBan
extends Effect {
    private Expression<?> players;
    @Nullable
    private Expression<String> reason;
    private boolean ban;
    private boolean ipBan;

    static {
        Skript.registerEffect(EffBan.class, "ban %strings/offlineplayers% [(by reason of|because [of]|on account of|due to) %-string%]", "unban %strings/offlineplayers%", "ban %players% by IP [(by reason of|because [of]|on account of|due to) %-string%]", "unban %players% by IP", "IP(-| )ban %players% [(by reason of|because [of]|on account of|due to) %-string%]", "(IP(-| )unban|un[-]IP[-]ban) %players%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        this.reason = exprs.length > 1 ? exprs[1] : null;
        this.ban = matchedPattern % 2 == 0;
        this.ipBan = matchedPattern >= 2;
        return true;
    }

    @Override
    protected void execute(Event e) {
        String reason = this.reason != null ? this.reason.getSingle(e) : null;
        Date expires = null;
        String source = "Skript ban effect";
        ?[] objArray = this.players.getArray(e);
        int n = objArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objArray[n2];
            if (o instanceof Player) {
                if (this.ipBan) {
                    String ip = ((Player)o).getAddress().getAddress().getHostAddress();
                    if (this.ban) {
                        Bukkit.getBanList((BanList.Type)BanList.Type.IP).addBan(ip, reason, expires, "Skript ban effect");
                    } else {
                        Bukkit.getBanList((BanList.Type)BanList.Type.IP).pardon(ip);
                    }
                } else if (this.ban) {
                    Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(((Player)o).getName(), reason, expires, "Skript ban effect");
                } else {
                    Bukkit.getBanList((BanList.Type)BanList.Type.NAME).pardon(((Player)o).getName());
                }
            } else if (o instanceof OfflinePlayer) {
                if (this.ban) {
                    Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(((OfflinePlayer)o).getName(), reason, expires, "Skript ban effect");
                } else {
                    Bukkit.getBanList((BanList.Type)BanList.Type.NAME).pardon(((OfflinePlayer)o).getName());
                }
            } else if (o instanceof String) {
                String s = (String)o;
                if (this.ban) {
                    Bukkit.getBanList((BanList.Type)BanList.Type.IP).addBan(s, reason, expires, "Skript ban effect");
                    Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(s, reason, expires, "Skript ban effect");
                } else {
                    Bukkit.getBanList((BanList.Type)BanList.Type.IP).pardon(s);
                    Bukkit.getBanList((BanList.Type)BanList.Type.NAME).pardon(s);
                }
            } else assert (false);
            ++n2;
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.ipBan ? "IP-" : "") + (this.ban ? "" : "un") + "ban " + this.players.toString(e, debug) + (this.reason != null ? " on account of " + this.reason.toString(e, debug) : "");
    }
}

