/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.aliases;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.aliases.MaterialRegistry;
import ch.njol.skript.bukkitutil.BukkitUnsafe;
import ch.njol.skript.bukkitutil.ItemUtils;
import ch.njol.skript.bukkitutil.block.BlockCompat;
import ch.njol.skript.bukkitutil.block.BlockValues;
import ch.njol.skript.localization.Message;
import ch.njol.skript.variables.Variables;
import ch.njol.yggdrasil.Fields;
import ch.njol.yggdrasil.YggdrasilSerializable;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.StreamCorruptedException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFactory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.eclipse.jdt.annotation.Nullable;

public class ItemData
implements Cloneable,
YggdrasilSerializable.YggdrasilExtendedSerializable {
    static final ItemFactory itemFactory;
    static final MaterialRegistry materialRegistry;
    private static final Message m_named;
    transient ItemStack stack;
    transient Material type;
    boolean isAnything;
    @Nullable
    transient BlockValues blockValues;
    boolean itemForm;
    boolean strictEquality;
    boolean isAlias;

    static {
        Variables.yggdrasil.registerSingleClass(ItemData.class, "NewItemData");
        Variables.yggdrasil.registerSingleClass(OldItemData.class, "ItemData");
        itemFactory = Bukkit.getServer().getItemFactory();
        Path materialsFile = Paths.get(Skript.getInstance().getDataFolder().getAbsolutePath(), "materials.json");
        if (Files.exists(materialsFile, new LinkOption[0])) {
            String content = null;
            try {
                content = new String(Files.readAllBytes(materialsFile), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                Skript.exception((Throwable)e, "Loading material registry failed!");
            }
            materialRegistry = content != null ? new MaterialRegistry((Material[])new Gson().fromJson(content, Material[].class)) : new MaterialRegistry();
        } else {
            materialRegistry = new MaterialRegistry();
            String content = new Gson().toJson((Object)materialRegistry.getMaterials());
            try {
                Files.write(materialsFile, content.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE_NEW);
            }
            catch (IOException e) {
                Skript.exception((Throwable)e, "Saving material registry failed!");
            }
        }
        m_named = new Message("aliases.named");
    }

    public ItemData(Material type, @Nullable String tags) {
        this.type = type;
        this.stack = new ItemStack(type);
        this.blockValues = BlockCompat.INSTANCE.getBlockValues(this.stack);
        if (tags != null) {
            BukkitUnsafe.modifyItemStack(this.stack, tags);
        }
        assert (this.stack != null);
        assert (this.stack != null);
    }

    public ItemData(Material type, int amount) {
        this.type = type;
        this.stack = new ItemStack(type, Math.abs(amount));
        this.blockValues = BlockCompat.INSTANCE.getBlockValues(this.stack);
    }

    public ItemData(Material type) {
        this(type, 1);
    }

    public ItemData(ItemData data) {
        this.stack = data.stack.clone();
        this.type = data.type;
        this.blockValues = data.blockValues;
        this.isAlias = data.isAlias;
    }

    public ItemData(ItemStack stack, @Nullable BlockValues values) {
        this.stack = stack;
        this.type = stack.getType();
        this.blockValues = values;
    }

    public ItemData(ItemStack stack) {
        this(stack, null);
        this.itemForm = true;
    }

    public ItemData(BlockState block) {
        this.type = block.getType();
        this.stack = new ItemStack(this.type);
        this.blockValues = BlockCompat.INSTANCE.getBlockValues(block);
    }

    public ItemData(Block block) {
        this(block.getState());
    }

    public ItemData() {
    }

    public boolean isOfType(@Nullable ItemStack item) {
        if (item == null) {
            return this.type == Material.AIR;
        }
        return item.isSimilar(this.stack);
    }

    public String toString() {
        return this.toString(false, false);
    }

    public String toString(boolean debug, boolean plural) {
        StringBuilder builder = new StringBuilder(Aliases.getMaterialName(this, plural));
        ItemMeta meta = this.stack.getItemMeta();
        if (meta != null && meta.hasDisplayName()) {
            builder.append(" ").append(m_named).append(" ");
            builder.append(meta.getDisplayName());
        }
        return builder.toString();
    }

    public int getGender() {
        return Aliases.getGender(this);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ItemData)) {
            return false;
        }
        ItemData other = (ItemData)obj;
        if (this.isAnything || other.isAnything) {
            return true;
        }
        BlockValues values = this.blockValues;
        if (this.itemForm && other.blockValues != null) {
            return other.blockValues.isDefault();
        }
        if (other.itemForm && this.blockValues != null) {
            return this.blockValues.isDefault();
        }
        if (this.strictEquality) {
            if (!Objects.equals(values, other.blockValues)) {
                return false;
            }
            if (values != null && other.blockValues != null && other.blockValues.isDefault() != values.isDefault()) {
                return false;
            }
        }
        if (values != null && !this.itemForm && !other.itemForm) {
            return values.equals(other.blockValues);
        }
        if (!this.type.equals((Object)other.type)) {
            return false;
        }
        if (!this.isAlias && !other.isAlias) {
            return Objects.equals(this.getItemMeta(), other.getItemMeta());
        }
        return true;
    }

    public int hashCode() {
        int hash = this.type.hashCode();
        if (this.blockValues == null || this.blockValues != null && this.blockValues.isDefault()) {
            hash = hash * 37 + 1;
        }
        return hash;
    }

    @Nullable
    public ItemData intersection(ItemData other) {
        if (other.type != this.type) {
            return null;
        }
        return this;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public ItemData clone() {
        return new ItemData(this);
    }

    public Material getType() {
        return this.type;
    }

    @Nullable
    public BlockValues getBlockValues() {
        return this.blockValues;
    }

    public ItemMeta getItemMeta() {
        return this.stack.getItemMeta();
    }

    public void setItemMeta(ItemMeta meta) {
        this.stack.setItemMeta(meta);
        this.isAlias = false;
    }

    public int getDurability() {
        return this.stack.getDurability();
    }

    public void setDurability(int durability) {
        this.stack.setDurability((short)durability);
        this.isAlias = false;
    }

    @Override
    public Fields serialize() throws NotSerializableException {
        Fields fields = new Fields(this);
        fields.putPrimitive("id", materialRegistry.getId(this.type));
        fields.putObject("meta", this.stack.getItemMeta());
        return fields;
    }

    @Override
    public void deserialize(Fields fields) throws StreamCorruptedException, NotSerializableException {
        this.type = materialRegistry.getMaterial(fields.getAndRemovePrimitive("id", Integer.TYPE));
        ItemMeta meta = fields.getAndRemoveObject("meta", ItemMeta.class);
        fields.setFields(this);
        this.stack = new ItemStack(this.type);
        this.stack.setItemMeta(meta);
    }

    public ItemData aliasCopy() {
        ItemData data = new ItemData();
        data.stack = new ItemStack(this.type, 1);
        if (this.stack.hasItemMeta()) {
            ItemMeta meta = this.stack.getItemMeta();
            meta.setDisplayName(null);
            data.stack.setItemMeta(meta);
        }
        ItemUtils.setDamage(data.stack, 0);
        data.type = this.type;
        data.blockValues = this.blockValues;
        data.itemForm = this.itemForm;
        return data;
    }

    public void applyMeta(ItemMeta meta) {
        ItemMeta our = this.stack.getItemMeta();
        if (meta.hasLore()) {
            our.setLore(meta.getLore());
        }
        if (meta.hasDisplayName()) {
            our.setDisplayName(meta.getDisplayName());
        }
        if (meta.hasEnchants()) {
            for (Map.Entry entry : meta.getEnchants().entrySet()) {
                our.addEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
            }
        }
        for (ItemFlag itemFlag : meta.getItemFlags()) {
            our.addItemFlags(new ItemFlag[]{itemFlag});
        }
        this.setItemMeta(meta);
    }

    public static class OldItemData {
        int typeid = -1;
        public short dataMin = (short)-1;
        public short dataMax = (short)-1;
    }
}

