/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.function;

import ch.njol.skript.SkriptConfig;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.function.FunctionEvent;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.function.Parameter;
import ch.njol.skript.lang.function.Signature;
import ch.njol.util.coll.CollectionUtils;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.eclipse.jdt.annotation.Nullable;

public abstract class Function<T> {
    public static boolean executeWithNulls = SkriptConfig.executeFunctionsWithMissingParams.value();
    final String name;
    final Parameter<?>[] parameters;
    @Nullable
    final ClassInfo<T> returnType;
    final boolean single;

    public Function(String name, Parameter<?>[] parameters, @Nullable ClassInfo<T> returnType, boolean single) {
        this.name = name;
        this.parameters = parameters;
        this.returnType = returnType;
        this.single = single;
    }

    public String getName() {
        return this.name;
    }

    public Parameter<?> getParameter(int index) {
        return this.parameters[index];
    }

    public Parameter<?>[] getParameters() {
        return this.parameters;
    }

    @Nullable
    public ClassInfo<T> getReturnType() {
        return this.returnType;
    }

    public boolean isSingle() {
        return this.single;
    }

    public int getMinParameters() {
        int i = this.parameters.length - 1;
        while (i >= 0) {
            if (this.parameters[i].def == null) {
                return i + 1;
            }
            --i;
        }
        return 0;
    }

    public int getMaxParameters() {
        return this.parameters.length;
    }

    @Nullable
    public final T[] execute(Object[][] params) {
        Object[][] ps;
        FunctionEvent e = new FunctionEvent(this);
        if (Functions.callFunctionEvents) {
            Bukkit.getPluginManager().callEvent(e);
        }
        if (params.length > this.parameters.length) {
            assert (false) : params.length;
            return null;
        }
        Object[][] objectArray = ps = params.length < this.parameters.length ? (Object[][])Arrays.copyOf(params, this.parameters.length) : params;
        assert (ps != null);
        int i = 0;
        while (i < this.parameters.length) {
            Object[] val;
            Parameter<?> p = this.parameters[i];
            Object object = i < params.length ? params[i] : (val = p.def != null ? p.def.getArray(e) : null);
            if (!(executeWithNulls || val != null && val.length != 0)) {
                return null;
            }
            ps[i] = val;
            ++i;
        }
        Object[] r = this.execute(e, ps);
        assert (!(this.returnType == null ? r != null : r != null && (r.length > 1 && this.single || CollectionUtils.contains(r, null) || !this.returnType.getC().isAssignableFrom(r.getClass().getComponentType())))) : this + "; " + Arrays.toString(r);
        return r == null || r.length > 0 ? r : null;
    }

    @Nullable
    public abstract T[] execute(FunctionEvent<?> var1, Object[][] var2);

    public abstract boolean resetReturnValue();

    public String toString() {
        return "function " + this.name;
    }

    public Signature<T> getSignature() {
        return new Signature<T>("unknown", this.name, Arrays.asList(this.parameters), this.returnType, null, this.single);
    }
}

