/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions.base;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.util.ConvertedExpression;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Converters;
import java.util.Iterator;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public abstract class WrapperExpression<T>
extends SimpleExpression<T> {
    private Expression<? extends T> expr;

    protected WrapperExpression() {
    }

    public WrapperExpression(SimpleExpression<? extends T> expr) {
        this.expr = expr;
    }

    protected void setExpr(Expression<? extends T> expr) {
        this.expr = expr;
    }

    public Expression<?> getExpr() {
        return this.expr;
    }

    @Override
    @Nullable
    protected <R> ConvertedExpression<T, ? extends R> getConvertedExpr(Class<R> ... to) {
        Class<R>[] classArray = to;
        int n = to.length;
        int n2 = 0;
        while (n2 < n) {
            Class<R> c = classArray[n2];
            assert (c != null);
            Converter<T, R> conv = Converters.getConverter(this.getReturnType(), c);
            if (conv != null) {
                return new ConvertedExpression<T, R>(this.expr, c, conv){

                    @Override
                    public String toString(@Nullable Event e, boolean debug) {
                        if (debug && e == null) {
                            return "(" + WrapperExpression.this.toString(e, debug) + ")->" + this.to.getName();
                        }
                        return WrapperExpression.this.toString(e, debug);
                    }
                };
            }
            ++n2;
        }
        return null;
    }

    @Override
    protected T[] get(Event e) {
        return this.expr.getArray(e);
    }

    @Override
    @Nullable
    public Iterator<? extends T> iterator(Event e) {
        return this.expr.iterator(e);
    }

    @Override
    public boolean isSingle() {
        return this.expr.isSingle();
    }

    @Override
    public boolean getAnd() {
        return this.expr.getAnd();
    }

    @Override
    public Class<? extends T> getReturnType() {
        return this.expr.getReturnType();
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return this.expr.acceptChange(mode);
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        this.expr.change(e, delta, mode);
    }

    @Override
    public boolean setTime(int time) {
        return this.expr.setTime(time);
    }

    @Override
    public int getTime() {
        return this.expr.getTime();
    }

    @Override
    public boolean isDefault() {
        return this.expr.isDefault();
    }

    @Override
    public Expression<? extends T> simplify() {
        return this.expr;
    }

    @Override
    @Nullable
    public Object[] beforeChange(Expression<?> changed, @Nullable Object[] delta) {
        return this.expr.beforeChange(changed, delta);
    }
}

