/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.CreeperData;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.entity.PlayerData;
import ch.njol.skript.entity.SkeletonData;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.OfflinePlayer;
import org.bukkit.SkullType;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Zombie;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Skull")
@Description(value={"Gets a skull item representing a player or an entity."})
@Examples(value={"give the victim's skull to the attacker", "set the block at the entity to the entity's skull"})
@Since(value="2.0")
public class ExprSkull
extends SimplePropertyExpression<Object, ItemType> {
    static {
        ExprSkull.register(ExprSkull.class, ItemType.class, "skull", "offlineplayers/entities/entitydatas");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!Skript.isRunningMinecraft(1, 4, 5)) {
            Skript.error("Skulls are only available in Bukkit 1.4.5+");
            return false;
        }
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Override
    @Nullable
    public ItemType convert(Object o) {
        if (o instanceof Skeleton || o instanceof SkeletonData) {
            if (o instanceof SkeletonData ? ((SkeletonData)o).isWither() : ((Skeleton)o).getSkeletonType() == Skeleton.SkeletonType.WITHER) {
                SkullType type = SkullType.WITHER;
            } else {
                SkullType type = SkullType.SKELETON;
            }
        } else if (o instanceof Zombie || o instanceof EntityData && Zombie.class.isAssignableFrom(((EntityData)o).getType())) {
            SkullType type = SkullType.ZOMBIE;
        } else if (o instanceof OfflinePlayer || o instanceof PlayerData) {
            SkullType type = SkullType.PLAYER;
        } else if (o instanceof Creeper || o instanceof CreeperData) {
            SkullType type = SkullType.CREEPER;
        } else if (o instanceof EnderDragon || o instanceof EntityData && EnderDragon.class.isAssignableFrom(((EntityData)o).getType())) {
            SkullType type = SkullType.DRAGON;
        } else {
            return null;
        }
        throw new UnsupportedOperationException("1.13 update");
    }

    @Override
    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    @Override
    protected String getPropertyName() {
        return "skull";
    }
}

