/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Numbers")
@Description(value={"All numbers between two given numbers, useful for looping.", "Use 'numbers' if your start is not an integer and you want to keep the fractional part of the start number constant, or use 'integers' if you only want to loop integers.", "You may want to use the 'times' expression instead, for instance 'loop 5 times:'"})
@Examples(value={"loop numbers from 2.5 to 5.5: # loops 2.5, 3.5, 4.5, 5.5", "loop integers from 2.9 to 5.1: # same as '3 to 5', i.e. loops 3, 4, 5"})
@Since(value="1.4.6")
public class ExprNumbers
extends SimpleExpression<Number> {
    private Expression<Number> start;
    private Expression<Number> end;
    boolean integer;

    static {
        Skript.registerExpression(ExprNumbers.class, Number.class, ExpressionType.COMBINED, "[(all [[of] the]|the)] (numbers|1\u00a6integers) (between|from) %number% (and|to) %number%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.start = exprs[0];
        this.end = exprs[1];
        this.integer = parseResult.mark == 1;
        return true;
    }

    @Nullable
    protected Number[] get(Event event) {
        boolean reverse;
        Number s = this.start.getSingle(event);
        Number f = this.end.getSingle(event);
        if (s == null || f == null) {
            return null;
        }
        boolean bl = reverse = s.doubleValue() > f.doubleValue();
        if (reverse) {
            Number temp = s;
            s = f;
            f = temp;
        }
        double amount = this.integer ? Math.floor(f.doubleValue()) - Math.ceil(s.doubleValue()) + 1.0 : Math.floor(f.doubleValue() - s.doubleValue() + 1.0);
        ArrayList<Number> list = new ArrayList<Number>();
        double low = this.integer ? Math.ceil(s.doubleValue()) : s.doubleValue();
        int i = 0;
        while ((double)i < amount) {
            if (this.integer) {
                list.add((long)low + (long)i);
            } else {
                list.add(low + (double)i);
            }
            ++i;
        }
        if (reverse) {
            Collections.reverse(list);
        }
        return list.toArray(new Number[0]);
    }

    @Override
    @Nullable
    public Iterator<Number> iterator(Event event) {
        boolean reverse;
        Number s = this.start.getSingle(event);
        Number f = this.end.getSingle(event);
        if (s == null || f == null) {
            return null;
        }
        boolean bl = reverse = s.doubleValue() > f.doubleValue();
        if (reverse) {
            Number temp = s;
            s = f;
            f = temp;
        }
        Number starting = s;
        Number finish = f;
        return new Iterator<Number>(starting, finish){
            double i;
            double max;
            {
                this.i = ExprNumbers.this.integer ? Math.ceil(number.doubleValue()) : number.doubleValue();
                this.max = ExprNumbers.this.integer ? Math.floor(number2.doubleValue()) : number2.doubleValue();
            }

            @Override
            public boolean hasNext() {
                return this.i <= this.max;
            }

            @Override
            public Number next() {
                double d;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (ExprNumbers.this.integer) {
                    double d2;
                    if (reverse) {
                        double d3 = this.max;
                        d2 = d3;
                        this.max = d3 - 1.0;
                    } else {
                        double d4 = this.i;
                        d2 = d4;
                        this.i = d4 + 1.0;
                    }
                    return (long)d2;
                }
                if (reverse) {
                    double d5 = this.max;
                    d = d5;
                    this.max = d5 - 1.0;
                } else {
                    double d6 = this.i;
                    d = d6;
                    this.i = d6 + 1.0;
                }
                return d;
            }
        };
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.integer ? "integers" : "numbers") + " from " + this.start.toString(e, debug) + " to " + this.end.toString(e, debug);
    }

    @Override
    public boolean isLoopOf(String s) {
        return this.integer && (s.equalsIgnoreCase("integer") || s.equalsIgnoreCase("int"));
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return this.integer ? Long.class : Double.class;
    }
}

