/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.bukkit.event.Event;

@Name(value="Filter")
@Description(value={"Filters a list based on a condition. For example, if you ran 'broadcast \"something\" and \"something else\" where [string input is \"something\"] only \"something\" would be broadcast as it is the only string that matched the condition."})
@Examples(value={"send \"congrats on being staff!\" to all players where [player input has permission \"staff\"]"})
@Since(value="2.2-dev36")
public class ExprFilter<T>
extends SimpleExpression<T> {
    private static ExprFilter<?> parsing;
    private ExprFilter<?> source;
    private Object current;
    private List<ExprInput<?>> children = new ArrayList();
    private Class<T> superType;
    private Condition condition;
    private String rawCond;
    private Expression<Object> objects;

    static {
        Skript.registerExpression(ExprFilter.class, Object.class, ExpressionType.COMBINED, "%objects% (where|that match) \\[<.+>\\]");
    }

    public ExprFilter() {
        this(null, Object.class);
    }

    public ExprFilter(ExprFilter<?> source, Class<? extends T> ... types) {
        this.source = source;
        if (source != null) {
            this.condition = source.condition;
            this.rawCond = source.rawCond;
            this.objects = source.objects;
            this.children = source.children;
            for (ExprInput<?> child : this.children) {
                child.setParent(this);
            }
        }
        this.superType = Utils.getSuperType(types);
    }

    public static ExprFilter<?> getParsing() {
        return parsing;
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        parsing = this;
        this.objects = LiteralUtils.defendExpression(exprs[0]);
        this.rawCond = parseResult.regexes.get(0).group();
        this.condition = Condition.parse(this.rawCond, "Can't understand this condition: " + this.rawCond);
        parsing = null;
        return this.condition != null && LiteralUtils.canInitSafely(this.objects);
    }

    @Override
    protected T[] get(Event e) {
        ArrayList<Object> filtered = new ArrayList<Object>();
        try {
            Object[] objectArray = this.objects.getArray(e);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object;
                this.current = object = objectArray[n2];
                if (this.condition.check(e)) {
                    filtered.add(object);
                }
                ++n2;
            }
        }
        finally {
            this.current = null;
        }
        try {
            return Converters.convertStrictly(filtered.toArray(), this.superType);
        }
        catch (ClassCastException e1) {
            return null;
        }
    }

    public Object getCurrent() {
        return this.current;
    }

    public void addChild(ExprInput<?> child) {
        this.children.add(child);
    }

    @Override
    public <R> Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        return new ExprFilter<R>(this, to);
    }

    @Override
    public Expression<?> getSource() {
        return this.source == null ? this : this.source;
    }

    @Override
    public Class<? extends T> getReturnType() {
        return this.superType;
    }

    @Override
    public boolean isSingle() {
        return this.objects.isSingle();
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.format("%s where [%s]", this.objects.toString(e, debug), this.rawCond);
    }

    @Override
    public boolean isLoopOf(String s) {
        for (ExprInput<?> child : this.children) {
            if (child.getClassInfo() == null) continue;
            Pattern[] patternArray = child.getClassInfo().getUserInputPatterns();
            int n = patternArray.length;
            int n2 = 0;
            while (n2 < n) {
                Pattern pattern = patternArray[n2];
                if (pattern.matcher(s).matches()) {
                    return true;
                }
                ++n2;
            }
        }
        return this.objects.isLoopOf(s);
    }

    @Name(value="Filter Input")
    @Description(value={"Represents the input in a filter expression. For example, if you ran 'broadcast \"something\" and \"something else\" where [string input is \"something\"] the condition would be checked twice, using \"something\" and \"something else\" as the inputs."})
    @Examples(value={"send \"congrats on being staff!\" to all players where [player input has permission \"staff\"]"})
    @Since(value="2.2-dev36")
    public static class ExprInput<T>
    extends SimpleExpression<T> {
        private ExprInput<?> source;
        private Class<T> superType;
        private ExprFilter<?> parent;
        private Literal<ClassInfo<?>> inputType;

        static {
            Skript.registerExpression(ExprInput.class, Object.class, ExpressionType.COMBINED, "[%-classinfo%] input");
        }

        public ExprInput() {
            this(null, Object.class);
        }

        public ExprInput(ExprInput<?> source, Class<? extends T> ... types) {
            this.source = source;
            if (source != null) {
                this.parent = source.parent;
                this.inputType = source.inputType;
                this.parent.addChild(this);
            }
            this.superType = Utils.getSuperType(types);
        }

        @Override
        public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
            if (ExprFilter.getParsing() == null || exprs[0] != null && !(exprs[0] instanceof Literal)) {
                return false;
            }
            this.parent = ExprFilter.getParsing();
            this.parent.addChild(this);
            this.inputType = (Literal)exprs[0];
            return true;
        }

        @Override
        protected T[] get(Event e) {
            Object current = this.parent.getCurrent();
            if (this.inputType != null && !this.inputType.getSingle().getC().isInstance(current)) {
                return null;
            }
            try {
                return Converters.convertStrictly(new Object[]{current}, this.superType);
            }
            catch (ClassCastException e1) {
                return (Object[])Array.newInstance(this.superType, 0);
            }
        }

        public void setParent(ExprFilter<?> parent) {
            this.parent = parent;
        }

        @Override
        public <R> Expression<? extends R> getConvertedExpression(Class<R> ... to) {
            return new ExprInput<R>(this, to);
        }

        @Override
        public Expression<?> getSource() {
            return this.source == null ? this : this.source;
        }

        @Override
        public Class<? extends T> getReturnType() {
            return this.superType;
        }

        public ClassInfo<?> getClassInfo() {
            return this.inputType == null ? null : this.inputType.getSingle();
        }

        @Override
        public boolean isSingle() {
            return true;
        }

        @Override
        public String toString(Event e, boolean debug) {
            return this.inputType == null ? "input" : String.format("%s input", this.inputType.toString(e, debug));
        }
    }
}

