/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.bukkitutil.PlayerUtils;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Testable;
import ch.njol.util.Kleenean;
import org.bukkit.Material;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.AbstractHorseInventory;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Equip")
@Description(value={"Equips a player with some given armor. This will replace any armor that the player is wearing."})
@Examples(value={"equip player with diamond helmet", "equip player with all diamond armor"})
@Since(value="1.0")
public class EffEquip
extends Effect
implements Testable {
    private Expression<LivingEntity> entities;
    private Expression<ItemType> types;
    private static final boolean supportsHorses;
    private static final boolean newHorses;
    private static final ItemType helmet;
    private static final ItemType chestplate;
    private static final ItemType leggings;
    private static final ItemType boots;
    private static final ItemType horseArmor;
    private static final ItemType saddle;
    private static final ItemType chest;

    static {
        Skript.registerEffect(EffEquip.class, "equip [%livingentity%] with %itemtypes%", "make %livingentity% wear %itemtypes%");
        supportsHorses = Skript.classExists("org.bukkit.entity.Horse");
        newHorses = Skript.classExists("org.bukkit.entity.AbstractHorse");
        helmet = Aliases.javaItemType("helmet");
        chestplate = Aliases.javaItemType("chestplate");
        leggings = Aliases.javaItemType("leggings");
        boots = Aliases.javaItemType("boots");
        horseArmor = Aliases.javaItemType("horse armor");
        saddle = Aliases.javaItemType("saddle");
        chest = Aliases.javaItemType("chest");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.entities = vars[0];
        this.types = vars[1];
        return true;
    }

    @Override
    protected void execute(Event e) {
        ItemType[] ts = this.types.getArray(e);
        LivingEntity[] livingEntityArray = this.entities.getArray(e);
        int n = livingEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemType[] itemTypeArray;
            AbstractHorseInventory invi;
            ItemType t;
            int n3;
            ItemType[] itemTypeArray2;
            LivingEntity en = livingEntityArray[n2];
            if (en instanceof Pig) {
                itemTypeArray2 = ts;
                n3 = ts.length;
                int n4 = 0;
                while (n4 < n3) {
                    t = itemTypeArray2[n4];
                    if (t.isOfType(Material.SADDLE)) {
                        ((Pig)en).setSaddle(true);
                        break;
                    }
                    ++n4;
                }
            } else if (newHorses && en instanceof AbstractHorse) {
                invi = ((AbstractHorse)en).getInventory();
                itemTypeArray = ts;
                int n5 = ts.length;
                n3 = 0;
                while (n3 < n5) {
                    ItemType t2 = itemTypeArray[n3];
                    for (ItemStack item : t2.getAll()) {
                        if (saddle.isOfType(item)) {
                            invi.setItem(0, item);
                            continue;
                        }
                        if (horseArmor.isOfType(item)) {
                            invi.setItem(1, item);
                            continue;
                        }
                        if (!chest.isOfType(item) || !(en instanceof ChestedHorse)) continue;
                        ((ChestedHorse)en).setCarryingChest(true);
                    }
                    ++n3;
                }
            } else if (supportsHorses && en instanceof Horse) {
                invi = ((Horse)en).getInventory();
                itemTypeArray = ts;
                int n6 = ts.length;
                n3 = 0;
                while (n3 < n6) {
                    ItemType t3 = itemTypeArray[n3];
                    for (ItemStack item : t3.getAll()) {
                        if (saddle.isOfType(item)) {
                            invi.setSaddle(item);
                            continue;
                        }
                        if (horseArmor.isOfType(item)) {
                            invi.setArmor(item);
                            continue;
                        }
                        if (!chest.isOfType(item)) continue;
                        ((Horse)en).setCarryingChest(true);
                    }
                    ++n3;
                }
            } else if (en.getEquipment() != null) {
                itemTypeArray2 = ts;
                n3 = ts.length;
                int n7 = 0;
                while (n7 < n3) {
                    t = itemTypeArray2[n7];
                    for (ItemStack item : t.getAll()) {
                        EntityEquipment equip = en.getEquipment();
                        if (helmet.isOfType(item) || item.getType().isBlock()) {
                            equip.setHelmet(item);
                            continue;
                        }
                        if (chestplate.isOfType(item)) {
                            equip.setChestplate(item);
                            continue;
                        }
                        if (leggings.isOfType(item)) {
                            equip.setLeggings(item);
                            continue;
                        }
                        if (!boots.isOfType(item)) continue;
                        equip.setBoots(item);
                    }
                    ++n7;
                }
                if (en instanceof Player) {
                    PlayerUtils.updateInventory((Player)en);
                }
            }
            ++n2;
        }
    }

    @Override
    public boolean test(Event e) {
        return false;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "equip " + this.entities.toString(e, debug) + " with " + this.types.toString(e, debug);
    }
}

