/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

public interface Converter<F, T> {
    public static final int NO_LEFT_CHAINING = 1;
    public static final int NO_RIGHT_CHAINING = 2;
    public static final int NO_CHAINING = 3;
    public static final int NO_COMMAND_ARGUMENTS = 4;

    @Nullable
    public T convert(F var1);

    @NonNullByDefault
    public static final class ConverterInfo<F, T> {
        public final Class<F> from;
        public final Class<T> to;
        public final Converter<F, T> converter;
        public final int options;

        public ConverterInfo(Class<F> from, Class<T> to, Converter<F, T> converter, int options) {
            this.from = from;
            this.to = to;
            this.converter = converter;
            this.options = options;
        }
    }

    public static final class ConverterUtils {
        public static <F, T> Converter<?, T> createInstanceofConverter(ConverterInfo<F, T> conv) {
            return ConverterUtils.createInstanceofConverter(conv.from, conv.converter);
        }

        public static <F, T> Converter<?, T> createInstanceofConverter(final Class<F> from, final Converter<F, T> conv) {
            return new Converter<Object, T>(){

                @Override
                @Nullable
                public T convert(Object o) {
                    if (!from.isInstance(o)) {
                        return null;
                    }
                    return conv.convert(o);
                }
            };
        }

        public static <F, T> Converter<F, T> createInstanceofConverter(final Converter<F, ?> conv, final Class<T> to) {
            return new Converter<F, T>(){

                @Override
                @Nullable
                public T convert(F f) {
                    Object o = conv.convert(f);
                    if (to.isInstance(o)) {
                        return o;
                    }
                    return null;
                }
            };
        }

        public static <F, T> Converter<?, T> createDoubleInstanceofConverter(ConverterInfo<F, ?> conv, Class<T> to) {
            return ConverterUtils.createDoubleInstanceofConverter(conv.from, conv.converter, to);
        }

        public static <F, T> Converter<?, T> createDoubleInstanceofConverter(final Class<F> from, final Converter<F, ?> conv, final Class<T> to) {
            return new Converter<Object, T>(){

                @Override
                @Nullable
                public T convert(Object o) {
                    if (!from.isInstance(o)) {
                        return null;
                    }
                    Object o2 = conv.convert(o);
                    if (to.isInstance(o2)) {
                        return o2;
                    }
                    return null;
                }
            };
        }
    }
}

