/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.bukkitutil;

import ch.njol.skript.Skript;
import ch.njol.skript.util.Version;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.UnsafeValues;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

public class BukkitUnsafe {
    private static final UnsafeValues unsafe;
    private static final boolean knownNullPtr;
    @Nullable
    private static MethodHandle unsafeFromInternalNameMethod;
    private static final boolean newMaterials;
    @Nullable
    private static Map<String, Material> materialMap;
    private static boolean preferMaterialMap;
    private static boolean unsafeValuesErrored;

    static {
        knownNullPtr = !Skript.isRunningMinecraft(1, 11);
        UnsafeValues values = Bukkit.getUnsafe();
        if (values == null) {
            throw new Error("UnsafeValues not available");
        }
        unsafe = values;
        newMaterials = Skript.isRunningMinecraft(1, 13);
        preferMaterialMap = true;
    }

    public static void initialize() {
        if (!newMaterials) {
            MethodHandle mh;
            try {
                mh = MethodHandles.lookup().findVirtual(UnsafeValues.class, "getMaterialFromInternalName", MethodType.methodType(Material.class, String.class));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                mh = null;
            }
            unsafeFromInternalNameMethod = mh;
            try {
                Version version = Skript.getMinecraftVersion();
                boolean mapExists = BukkitUnsafe.loadMaterialMap("materials/" + version.getMajor() + "." + version.getMinor() + ".json");
                if (!mapExists) {
                    BukkitUnsafe.loadMaterialMap("materials/1.9.json");
                    preferMaterialMap = false;
                    Skript.warning("Material mappings for " + version + " are not available.");
                    Skript.warning("Depending on your server software, some aliases may not work.");
                }
            }
            catch (IOException e) {
                Skript.exception((Throwable)e, "Failed to load material mappings. Aliases may not work properly.");
            }
        }
    }

    @Nullable
    public static Material getMaterialFromMinecraftId(String id) {
        Material type;
        block9: {
            if (newMaterials) {
                if (id.length() > 9) {
                    return Material.matchMaterial((String)id.substring(10));
                }
                return null;
            }
            if (preferMaterialMap && id.length() > 9) {
                assert (materialMap != null);
                return materialMap.get(id.substring(10));
            }
            type = null;
            try {
                assert (unsafeFromInternalNameMethod != null);
                type = unsafeFromInternalNameMethod.invokeExact(unsafe, id);
            }
            catch (Throwable e) {
                if (unsafeValuesErrored && !Skript.debug()) break block9;
                Skript.exception(e, "UnsafeValues failed to get material from Vanilla id");
                unsafeValuesErrored = true;
            }
        }
        if (type == null || type == Material.AIR) {
            assert (materialMap != null);
            return materialMap.get(id);
        }
        return type;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean loadMaterialMap(String name) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream is = Skript.getInstance().getResource(name);){
            if (is == null) {
                return false;
            }
            String data = new String(ByteStreams.toByteArray((InputStream)is), StandardCharsets.UTF_8);
            Type type = new TypeToken<Map<String, Material>>(){}.getType();
            materialMap = (Map)new Gson().fromJson(data, type);
            return true;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    public static void modifyItemStack(ItemStack stack, String arguments) {
        try {
            unsafe.modifyItemStack(stack, arguments);
        }
        catch (NullPointerException e) {
            if (knownNullPtr) {
                Skript.warning("Item " + stack.getType() + arguments + " failed modifyItemStack. This is a bug on old Spigot versions.");
            }
            throw e;
        }
    }
}

