/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.hooks.economy.classes;

import ch.njol.skript.classes.Arithmetic;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.hooks.VaultHook;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Comparators;
import ch.njol.skript.registrations.Converters;
import ch.njol.util.StringUtils;
import org.eclipse.jdt.annotation.Nullable;

public class Money {
    final double amount;

    static {
        Classes.registerClass(new ClassInfo<Money>(Money.class, "money").user("money").name("Money").description("A certain amount of money. Please note that this differs from <a href='#number'>numbers</a> as it includes a currency symbol or name, but usually the two are interchangeable, e.g. you can both <code>add 100$ to the player's balance</code> and <code>add 100 to the player's balance</code>.").usage("<code>&lt;number&gt; $</code> or <code>$ &lt;number&gt;</code>, where '$' is your server's currency, e.g. '10 rupees' or '\u00a35.00'").examples("add 10\u00a3 to the player's account", "remove Fr. 9.95 from the player's money", "set the victim's money to 0", "increase the attacker's balance by the level of the victim * 100").since("2.0").before("itemtype", "itemstack").parser(new Parser<Money>(){

            @Override
            @Nullable
            public Money parse(String s, ParseContext context) {
                return Money.parse(s);
            }

            @Override
            public String toString(Money m, int flags) {
                return m.toString();
            }

            @Override
            public String toVariableNameString(Money o) {
                return "money:" + o.amount;
            }

            @Override
            public String getVariableNamePattern() {
                return "money:-?\\d+(\\.\\d+)?";
            }
        }).math(Money.class, new Arithmetic<Money, Money>(){

            @Override
            public Money difference(Money first, Money second) {
                double d = Math.abs(first.getAmount() - second.getAmount());
                if (d < 1.0E-10) {
                    return new Money(0.0);
                }
                return new Money(d);
            }

            @Override
            public Money add(Money value, Money difference) {
                return new Money(value.amount + difference.amount);
            }

            @Override
            public Money subtract(Money value, Money difference) {
                return new Money(value.amount - difference.amount);
            }

            @Override
            public Money multiply(Money value, Money multiplier) {
                return new Money(value.getAmount() * multiplier.getAmount());
            }

            @Override
            public Money divide(Money value, Money divider) {
                return new Money(value.getAmount() / divider.getAmount());
            }

            @Override
            public Money power(Money value, Money exponent) {
                throw new UnsupportedOperationException();
            }
        }));
        Comparators.registerComparator(Money.class, Money.class, new Comparator<Money, Money>(){

            @Override
            public Comparator.Relation compare(Money m1, Money m2) {
                return Comparator.Relation.get(m1.amount - m2.amount);
            }

            @Override
            public boolean supportsOrdering() {
                return true;
            }
        });
        Comparators.registerComparator(Money.class, Number.class, new Comparator<Money, Number>(){

            @Override
            public Comparator.Relation compare(Money m, Number n) {
                return Comparator.Relation.get(m.amount - n.doubleValue());
            }

            @Override
            public boolean supportsOrdering() {
                return true;
            }
        });
        Converters.registerConverter(Money.class, Double.class, new Converter<Money, Double>(){

            @Override
            public Double convert(Money m) {
                return m.getAmount();
            }
        });
    }

    public Money(double amount) {
        this.amount = amount;
    }

    public double getAmount() {
        return this.amount;
    }

    @Nullable
    public static Money parse(String s) {
        if (VaultHook.economy == null) {
            return null;
        }
        String singular = VaultHook.economy.currencyNameSingular();
        String plural = VaultHook.economy.currencyNamePlural();
        if (!plural.isEmpty()) {
            if (StringUtils.endsWithIgnoreCase(s, plural)) {
                try {
                    double d = Double.parseDouble(s.substring(0, s.length() - plural.length()).trim());
                    return new Money(d);
                }
                catch (NumberFormatException d) {}
            } else if (StringUtils.startsWithIgnoreCase(s, plural)) {
                try {
                    double d = Double.parseDouble(s.substring(plural.length()).trim());
                    return new Money(d);
                }
                catch (NumberFormatException d) {
                    // empty catch block
                }
            }
        }
        if (!singular.isEmpty()) {
            if (StringUtils.endsWithIgnoreCase(s, singular)) {
                try {
                    double d = Double.parseDouble(s.substring(0, s.length() - singular.length()).trim());
                    return new Money(d);
                }
                catch (NumberFormatException d) {}
            } else if (StringUtils.startsWithIgnoreCase(s, singular)) {
                try {
                    double d = Double.parseDouble(s.substring(singular.length()).trim());
                    return new Money(d);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public String toString() {
        return VaultHook.economy.format(this.amount);
    }
}

