/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.util.Getter;
import ch.njol.util.Kleenean;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Formatted Time")
@Description(value={"Converts date to human-readable text format. By default, 'yyyy-MM-dd HH:mm:ss z' (e.g. '2018-03-30 16:03:12 +01') will be used. For reference, see this <a href=\"https://en.wikipedia.org/wiki/ISO_8601\">Wikipedia article</a>."})
@Examples(value={"now formatted human-readable"})
@Since(value="2.2-dev31")
public class ExprFormatTime
extends PropertyExpression<ch.njol.skript.util.Date, String> {
    private static final String defaultFormat = "yyyy-MM-dd HH:mm:ss z";
    private SimpleDateFormat format;

    static {
        Skript.registerExpression(ExprFormatTime.class, String.class, ExpressionType.PROPERTY, "%dates% formatted [human-readable] [(with|as) %-string%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        if (exprs[1] != null) {
            VariableString str;
            if (!(exprs[1] instanceof Literal) && !(str = (VariableString)exprs[1]).isSimple()) {
                Skript.error("Date format must not contain variables!");
                return false;
            }
            this.format = new SimpleDateFormat((String)exprs[1].getSingle(null));
        } else {
            this.format = new SimpleDateFormat(defaultFormat);
        }
        return true;
    }

    protected String[] get(Event e, ch.njol.skript.util.Date[] source) {
        return this.get(source, new Getter<String, ch.njol.skript.util.Date>(){

            @Override
            public String get(ch.njol.skript.util.Date date) {
                return ExprFormatTime.this.format.format(new Date(date.getTimestamp()));
            }
        });
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.getExpr().toString(e, debug)) + " formatted as " + this.format.toPattern();
    }
}

