/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Skript;
import ch.njol.skript.localization.GeneralWords;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.LanguageChangeListener;
import ch.njol.skript.localization.Noun;
import ch.njol.skript.util.Utils;
import ch.njol.util.NonNullPair;
import ch.njol.util.coll.CollectionUtils;
import ch.njol.yggdrasil.YggdrasilSerializable;
import java.util.HashMap;
import org.eclipse.jdt.annotation.Nullable;

public class Timespan
implements YggdrasilSerializable,
Comparable<Timespan> {
    private static final Noun m_tick = new Noun("time.tick");
    private static final Noun m_second = new Noun("time.second");
    private static final Noun m_minute = new Noun("time.minute");
    private static final Noun m_hour = new Noun("time.hour");
    private static final Noun m_day = new Noun("time.day");
    static final Noun[] names = new Noun[]{m_tick, m_second, m_minute, m_hour, m_day};
    static final long[] times = new long[]{50L, 1000L, 60000L, 3600000L, 86400000L};
    static final HashMap<String, Long> parseValues = new HashMap();
    private final long millis;
    static final NonNullPair<Noun, Long>[] simpleValues;

    static {
        Language.addListener(new LanguageChangeListener(){

            @Override
            public void onLanguageChange() {
                int i = 0;
                while (i < names.length) {
                    parseValues.put(names[i].getSingular().toLowerCase(), times[i]);
                    parseValues.put(names[i].getPlural().toLowerCase(), times[i]);
                    ++i;
                }
            }
        });
        simpleValues = new NonNullPair[]{new NonNullPair<Noun, Long>(m_day, 86400000L), new NonNullPair<Noun, Long>(m_hour, 3600000L), new NonNullPair<Noun, Long>(m_minute, 60000L), new NonNullPair<Noun, Long>(m_second, 1000L)};
    }

    @Nullable
    public static Timespan parse(String s) {
        if (s.isEmpty()) {
            return null;
        }
        long t = 0L;
        boolean minecraftTime = false;
        boolean isMinecraftTimeSet = false;
        if (s.matches("^\\d+:\\d\\d(:\\d\\d)?(\\.\\d{1,4})?$")) {
            String[] ss = s.split("[:.]");
            long[] times = new long[]{3600000L, 60000L, 1000L, 1L};
            int offset = ss.length == 3 && !s.contains(".") || ss.length == 4 ? 0 : 1;
            int i = 0;
            while (i < ss.length) {
                t += times[offset + i] * Utils.parseLong(ss[i]);
                ++i;
            }
        } else {
            String[] subs = s.toLowerCase().split("\\s+");
            int i = 0;
            while (i < subs.length) {
                String sub = subs[i];
                if (sub.equals(GeneralWords.and.toString())) {
                    if (i == 0 || i == subs.length - 1) {
                        return null;
                    }
                } else {
                    Long d;
                    double amount = 1.0;
                    if (Noun.isIndefiniteArticle(sub)) {
                        if (i == subs.length - 1) {
                            return null;
                        }
                        amount = 1.0;
                        sub = subs[++i];
                    } else if (sub.matches("^\\d+(.\\d+)?$")) {
                        if (i == subs.length - 1) {
                            return null;
                        }
                        amount = Double.parseDouble(sub);
                        sub = subs[++i];
                    }
                    if (CollectionUtils.contains(Language.getList("time.real"), sub)) {
                        if (i == subs.length - 1 || isMinecraftTimeSet && minecraftTime) {
                            return null;
                        }
                        sub = subs[++i];
                    } else if (CollectionUtils.contains(Language.getList("time.minecraft"), sub)) {
                        if (i == subs.length - 1 || isMinecraftTimeSet && !minecraftTime) {
                            return null;
                        }
                        minecraftTime = true;
                        sub = subs[++i];
                    }
                    if (sub.endsWith(",")) {
                        sub = sub.substring(0, sub.length() - 1);
                    }
                    if ((d = parseValues.get(sub.toLowerCase())) == null) {
                        return null;
                    }
                    if (minecraftTime && d != times[0]) {
                        amount /= 72.0;
                    }
                    t += Math.round(amount * (double)d.longValue());
                    isMinecraftTimeSet = true;
                }
                ++i;
            }
        }
        return new Timespan(t);
    }

    public Timespan() {
        this.millis = 0L;
    }

    public Timespan(long millis) {
        if (millis < 0L) {
            throw new IllegalArgumentException("millis must be >= 0");
        }
        this.millis = millis;
    }

    @Deprecated
    public static Timespan fromTicks(int ticks) {
        return new Timespan((long)ticks * 50L);
    }

    public static Timespan fromTicks_i(long ticks) {
        return new Timespan(ticks * 50L);
    }

    public long getMilliSeconds() {
        return this.millis;
    }

    public long getTicks_i() {
        return Math.round((double)this.millis / 50.0);
    }

    @Deprecated
    public int getTicks() {
        return Math.round(((float)this.millis >= Float.MAX_VALUE ? Float.MAX_VALUE : (float)this.millis) / 50.0f);
    }

    public String toString() {
        return Timespan.toString(this.millis);
    }

    public String toString(int flags) {
        return Timespan.toString(this.millis, flags);
    }

    public static String toString(long millis) {
        return Timespan.toString(millis, 0);
    }

    public static String toString(long millis, int flags) {
        int i = 0;
        while (i < simpleValues.length - 1) {
            if (millis >= simpleValues[i].getSecond()) {
                double second = 1.0 * (double)(millis % simpleValues[i].getSecond()) / (double)simpleValues[i + 1].getSecond().longValue();
                if (!"0".equals(Skript.toString(second))) {
                    return String.valueOf(Timespan.toString(Math.floor(1.0 * (double)millis / (double)simpleValues[i].getSecond().longValue()), simpleValues[i], flags)) + " " + GeneralWords.and + " " + Timespan.toString(second, simpleValues[i + 1], flags);
                }
                return Timespan.toString(1.0 * (double)millis / (double)simpleValues[i].getSecond().longValue(), simpleValues[i], flags);
            }
            ++i;
        }
        return Timespan.toString(1.0 * (double)millis / (double)simpleValues[simpleValues.length - 1].getSecond().longValue(), simpleValues[simpleValues.length - 1], flags);
    }

    private static String toString(double amount, NonNullPair<Noun, Long> p, int flags) {
        return p.getFirst().withAmount(amount, flags);
    }

    @Override
    public int compareTo(@Nullable Timespan o) {
        long d;
        long l = d = o == null ? this.millis : this.millis - o.millis;
        return d > 0L ? 1 : (d < 0L ? -1 : 0);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.millis / Integer.MAX_VALUE);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Timespan)) {
            return false;
        }
        Timespan other = (Timespan)obj;
        return this.millis == other.millis;
    }
}

