/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="TPS (ticks per second)")
@Description(value={"Returns the 3 most recent TPS readings, like the /tps command. This expression is only supported on some server software."})
@Examples(value={"broadcast \"%tps%\""})
@Since(value="2.2-dev36")
public class ExprTPS
extends SimpleExpression<Double> {
    private static final boolean SUPPORTED = Skript.methodExists(Server.class, "getTPS", new Class[0]);
    private int index;
    private String expr = "tps";

    static {
        Skript.registerExpression(ExprTPS.class, Double.class, ExpressionType.SIMPLE, "tps from [the] last ([1] minute|1[ ]m[inute])", "tps from [the] last 5[ ]m[inutes]", "tps from [the] last 15[ ]m[inutes]", "[the] tps");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!SUPPORTED) {
            Skript.error("The TPS expression is not supported on this server software");
            return false;
        }
        this.expr = parseResult.expr;
        this.index = matchedPattern;
        return true;
    }

    protected Double[] get(Event e) {
        double[] tps = Bukkit.getServer().getTPS();
        if (this.index != 3) {
            return new Double[]{tps[this.index]};
        }
        return CollectionUtils.wrap(tps);
    }

    @Override
    public Class<? extends Double> getReturnType() {
        return Double.class;
    }

    @Override
    public boolean isSingle() {
        return this.index != 3;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return this.expr;
    }
}

