/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.bukkitutil.PassengerUtils;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Passenger")
@Description(value={"The passenger of a vehicle, or the rider of a mob.", "See also: <a href='#ExprVehicle'>vehicle</a>", "For 1.11.2 and above, it returns a list of passengers and you can use all changers in it."})
@Examples(value={"#for 1.11 and lower", "passenger of the minecart is a creeper or a cow", "the saddled pig's passenger is a player", "#for 1.11.2+", "passengers of the minecart contains a creeper or a cow", "the boat's passenger contains a pig", "add a cow and a zombie to passengers of last spawned boat", "set passengers of player's vehicle to a pig and a horse", "remove all pigs from player's vehicle", "clear passengers of boat"})
@Since(value="2.0, 2.2-dev26 (Multiple passengers for 1.11.2+)")
public class ExprPassenger
extends SimpleExpression<Entity> {
    private Expression<Entity> vehicle;

    static {
        Skript.registerExpression(ExprPassenger.class, Entity.class, ExpressionType.PROPERTY, "[the] passenger[s] of %entities%", "%entities%'[s] passenger[s]");
    }

    @Nullable
    protected Entity[] get(final Event e) {
        Entity[] source = this.vehicle.getAll(e);
        Converter<Entity, Entity[]> conv = new Converter<Entity, Entity[]>(){

            @Override
            @Nullable
            public Entity[] convert(Entity v) {
                if (ExprPassenger.this.getTime() >= 0 && e instanceof VehicleEnterEvent && v.equals(((VehicleEnterEvent)e).getVehicle()) && !Delay.isDelayed(e)) {
                    return new Entity[]{((VehicleEnterEvent)e).getEntered()};
                }
                if (ExprPassenger.this.getTime() >= 0 && e instanceof VehicleExitEvent && v.equals(((VehicleExitEvent)e).getVehicle()) && !Delay.isDelayed(e)) {
                    return new Entity[]{((VehicleExitEvent)e).getExited()};
                }
                return PassengerUtils.getPassenger(v);
            }
        };
        ArrayList<Entity> entities = new ArrayList<Entity>();
        Entity[] entityArray = source;
        int n = source.length;
        int n2 = 0;
        while (n2 < n) {
            Entity[] array;
            Entity v = entityArray[n2];
            if (v != null && (array = (Entity[])conv.convert(v)) != null && array.length > 0) {
                entities.addAll(Arrays.asList(array));
            }
            ++n2;
        }
        return entities.toArray(new Entity[entities.size()]);
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.vehicle = exprs[0];
        return true;
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (!this.isSingle()) {
            return new Class[]{Entity[].class, EntityData[].class};
        }
        if (mode == Changer.ChangeMode.SET) {
            return new Class[]{Entity.class, EntityData.class};
        }
        return super.acceptChange(mode);
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Entity[] vehicles = this.vehicle.getArray(e);
        if (!this.isSingle() || mode == Changer.ChangeMode.SET) {
            Entity[] entityArray = vehicles;
            int n = vehicles.length;
            int n2 = 0;
            while (n2 < n) {
                Entity vehicle = entityArray[n2];
                if (vehicle != null) {
                    switch (mode) {
                        case SET: {
                            vehicle.eject();
                        }
                        case ADD: {
                            Entity passenger;
                            Object obj;
                            if (delta == null || delta.length == 0) {
                                return;
                            }
                            Object[] objectArray = delta;
                            int n3 = delta.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                obj = objectArray[n4];
                                if (obj != null) {
                                    passenger = obj instanceof Entity ? (Entity)obj : ((EntityData)obj).spawn(vehicle.getLocation());
                                    PassengerUtils.addPassenger(vehicle, passenger);
                                }
                                ++n4;
                            }
                            break;
                        }
                        case REMOVE: 
                        case REMOVE_ALL: {
                            Entity passenger;
                            Object obj;
                            if (delta == null || delta.length == 0) {
                                return;
                            }
                            Object[] objectArray = delta;
                            int n3 = delta.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                obj = objectArray[n4];
                                if (obj != null) {
                                    if (obj instanceof Entity) {
                                        PassengerUtils.removePassenger(vehicle, (Entity)obj);
                                    } else {
                                        Entity[] entityArray2 = PassengerUtils.getPassenger(vehicle);
                                        int n5 = entityArray2.length;
                                        int n6 = 0;
                                        while (n6 < n5) {
                                            passenger = entityArray2[n6];
                                            if (passenger != null && ((EntityData)obj).isInstance(passenger)) {
                                                PassengerUtils.removePassenger(vehicle, passenger);
                                            }
                                            ++n6;
                                        }
                                    }
                                }
                                ++n4;
                            }
                            break;
                        }
                        case DELETE: 
                        case RESET: {
                            vehicle.eject();
                        }
                    }
                }
                ++n2;
            }
        } else {
            super.change(e, delta, mode);
        }
    }

    @Override
    public Class<? extends Entity> getReturnType() {
        return Entity.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the passenger of " + this.vehicle.toString(e, debug);
    }

    @Override
    public boolean isSingle() {
        return !PassengerUtils.hasMultiplePassenger() ? this.vehicle.isSingle() : false;
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, this.vehicle, VehicleEnterEvent.class, VehicleExitEvent.class);
    }
}

