/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.bukkitutil.PlayerUtils;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.destroystokyo.paper.event.server.PaperServerListPingEvent;
import org.bukkit.event.Event;
import org.bukkit.event.server.ServerListPingEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Online Player Count")
@Description(value={"The amount of online players. This can be changed in a", "<a href='events.html#server_list_ping'>server list ping</a> event only to show fake online player amount.", "'real online player count' returns the real count of online players always and can't be changed.", "", "Fake online player count requires PaperSpigot 1.12.2+."})
@Examples(value={"on server list ping:", "\t# This will make the max players count 5 if there are 4 players online.", "\tset the fake max players count to (online players count + 1)"})
@Since(value="2.3")
public class ExprOnlinePlayersCount
extends SimpleExpression<Number> {
    private static final boolean PAPER_EVENT_EXISTS;
    private boolean isReal;

    static {
        Skript.registerExpression(ExprOnlinePlayersCount.class, Number.class, ExpressionType.PROPERTY, "[the] [(1\u00a6(real|default)|2\u00a6(fake|shown|displayed))] [online] player (count|amount|number)", "[the] [(1\u00a6(real|default)|2\u00a6(fake|shown|displayed))] (count|amount|number|size) of online players");
        PAPER_EVENT_EXISTS = Skript.classExists("com.destroystokyo.paper.event.server.PaperServerListPingEvent");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        boolean isPaperEvent;
        boolean bl = isPaperEvent = PAPER_EVENT_EXISTS && ScriptLoader.isCurrentEvent(PaperServerListPingEvent.class);
        if (parseResult.mark == 2) {
            if (ScriptLoader.isCurrentEvent(ServerListPingEvent.class)) {
                Skript.error("The 'fake' online players count expression requires Paper 1.12.2 or newer");
                return false;
            }
            if (!isPaperEvent) {
                Skript.error("The 'fake' online players count expression can't be used outside of a server list ping event");
                return false;
            }
        }
        this.isReal = parseResult.mark == 0 && !isPaperEvent || parseResult.mark == 1;
        return true;
    }

    @Nullable
    public Number[] get(Event e) {
        if (this.isReal) {
            return CollectionUtils.array(PlayerUtils.getOnlinePlayers().size());
        }
        return CollectionUtils.array(((PaperServerListPingEvent)e).getNumPlayers());
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (!this.isReal) {
            if (ScriptLoader.hasDelayBefore.isTrue()) {
                Skript.error("Can't change the shown online players count anymore after the server list ping event has already passed");
                return null;
            }
            switch (mode) {
                case ADD: 
                case SET: 
                case REMOVE: 
                case DELETE: 
                case RESET: {
                    return CollectionUtils.array(Number.class);
                }
            }
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        PaperServerListPingEvent event = (PaperServerListPingEvent)e;
        switch (mode) {
            case SET: {
                event.setNumPlayers(((Number)delta[0]).intValue());
                break;
            }
            case ADD: {
                event.setNumPlayers(event.getNumPlayers() + ((Number)delta[0]).intValue());
                break;
            }
            case REMOVE: {
                event.setNumPlayers(event.getNumPlayers() - ((Number)delta[0]).intValue());
                break;
            }
            case DELETE: 
            case RESET: {
                event.setNumPlayers(PlayerUtils.getOnlinePlayers().size());
            }
        }
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the count of " + (this.isReal ? "real max players" : "max players");
    }
}

