/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.WrapperExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Location")
@Description(value={"The location of a block or entity. This not only represents the x, y and z coordinates of the location but also includes the world and the direction an entity is looking (e.g. teleporting to a saved location will make the teleported entity face the same saved direction every time).", "Please note that the location of an entity is at it's feet, use <a href='#ExprEyeLocation'>head location</a> to get the location of the head."})
@Examples(value={"set {home.%player%} to the location of the player", "message \"You home was set to %player's location% in %player's world%.\""})
@Since(value="")
public class ExprLocationOf
extends WrapperExpression<Location> {
    static {
        Skript.registerExpression(ExprLocationOf.class, Location.class, ExpressionType.PROPERTY, "(location|position) of %location%", "%location%'[s] (location|position)");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the location of " + this.getExpr().toString(e, debug);
    }
}

