/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import java.util.Arrays;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.inventory.meta.ItemMeta;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Item with Lore")
@Description(value={"Returns the given item type with the specified lore added to it.", "If multiple strings are passed, each of them will be a separate line in the lore."})
@Examples(value={"set {_test} to stone with lore \"line 1\" and \"line 2\"", "give {_test} to player"})
@Since(value="2.3")
public class ExprItemWithLore
extends PropertyExpression<ItemType, ItemType> {
    private Expression<String> lore;

    static {
        Skript.registerExpression(ExprItemWithLore.class, ItemType.class, ExpressionType.PROPERTY, "%itemtypes% with [(a|the)] lore %strings%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        this.lore = exprs[1];
        return true;
    }

    protected ItemType[] get(Event e, ItemType[] itemTypes) {
        String[] lore = this.lore.getArray(e);
        if (lore == null) {
            return new ItemType[0];
        }
        return (ItemType[])Stream.of(itemTypes).map(itemType -> {
            ItemMeta meta = (itemType = itemType.clone()).getItemMeta();
            if (meta == null) {
                meta = Bukkit.getItemFactory().getItemMeta(Material.STONE);
            }
            meta.setLore(Arrays.asList(StringUtils.join(lore, "\n").split("\n")));
            itemType.setItemMeta(meta);
            return itemType;
        }).toArray(ItemType[]::new);
    }

    @Override
    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.getExpr().toString(e, debug)) + " with lore " + this.lore.toString(e, debug);
    }
}

