/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.destroystokyo.paper.event.server.PaperServerListPingEvent;
import com.destroystokyo.paper.profile.PlayerProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Hover List")
@Description(value={"The list when you hover on the player counts of the server in the server list.", "This can be changed using texts or players in a <a href='events.html#server_list_ping'>server list ping</a> event only. Adding players to the list means adding name of the players.", "And note that, for example if there are 5 online players (includes <a href='#ExprOnlinePlayersCount'>fake online count</a>) in the server and the hover list is set to 3 values, Minecraft will show \"... and 2 more ...\" at end of the list."})
@Examples(value={"on server list ping:", "\tclear the hover list", "\tadd \"<light green>Welcome to the <orange>Minecraft <light green>server!\" to the hover list", "\tadd \"\" to the hover list # A blank line", "\tadd \"<light red>There are <orange>%online players count% <light red>online players!\""})
@Since(value="2.3")
@RequiredPlugins(value={"Paper 1.12.2 or newer"})
@Events(value={"server list ping"})
public class ExprHoverList
extends SimpleExpression<String> {
    private static final boolean PAPER_EVENT_EXISTS;

    static {
        Skript.registerExpression(ExprHoverList.class, String.class, ExpressionType.SIMPLE, "[the] [custom] [(player|server)] (hover|sample) ([message] list|message)", "[the] [custom] player [(hover|sample)] list");
        PAPER_EVENT_EXISTS = Skript.classExists("com.destroystokyo.paper.event.server.PaperServerListPingEvent");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!PAPER_EVENT_EXISTS) {
            Skript.error("The hover list expression requires Paper 1.12.2 or newer");
            return false;
        }
        if (!ScriptLoader.isCurrentEvent(PaperServerListPingEvent.class)) {
            Skript.error("The hover list expression can't be used outside of a server list ping event");
            return false;
        }
        return true;
    }

    @Nullable
    public String[] get(Event e) {
        return (String[])((PaperServerListPingEvent)e).getPlayerSample().stream().map(PlayerProfile::getName).toArray(String[]::new);
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (ScriptLoader.hasDelayBefore.isTrue()) {
            Skript.error("Can't change the hover list anymore after the server list ping event has already passed");
            return null;
        }
        switch (mode) {
            case ADD: 
            case SET: 
            case REMOVE: 
            case DELETE: 
            case RESET: {
                return CollectionUtils.array(String[].class, Player[].class);
            }
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        ArrayList<PlayerProfile> values = new ArrayList<PlayerProfile>();
        if (mode != Changer.ChangeMode.DELETE && mode != Changer.ChangeMode.RESET) {
            Object[] objectArray = delta;
            int n = delta.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof Player) {
                    Player player = (Player)o;
                    values.add(Bukkit.createProfile((UUID)player.getUniqueId(), (String)player.getName()));
                } else {
                    values.add(Bukkit.createProfile((UUID)UUID.randomUUID(), (String)((String)o)));
                }
                ++n2;
            }
        }
        List sample = ((PaperServerListPingEvent)e).getPlayerSample();
        switch (mode) {
            case SET: {
                sample.clear();
                sample.addAll(values);
                break;
            }
            case ADD: {
                sample.addAll(values);
                break;
            }
            case REMOVE: {
                sample.removeAll(values);
                break;
            }
            case DELETE: 
            case RESET: {
                sample.clear();
            }
        }
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the hover list";
    }
}

