/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.slot.CursorSlot;
import ch.njol.skript.util.slot.Slot;
import org.bukkit.entity.Player;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Cursor Slot")
@Description(value={"The item which player has on their cursor. This slot is always empty if player has no inventories open."})
@Examples(value={"cursor slot of player is dirt", "set cursor slot of player to 64 diamonds"})
@Since(value="2.2-dev17")
public class ExprCursorSlot
extends SimplePropertyExpression<Player, Slot> {
    static {
        ExprCursorSlot.register(ExprCursorSlot.class, Slot.class, "cursor slot", "players");
    }

    @Override
    public Class<? extends Slot> getReturnType() {
        return Slot.class;
    }

    @Override
    protected String getPropertyName() {
        return "cursor slot";
    }

    @Override
    @Nullable
    public Slot convert(Player player) {
        return new CursorSlot(player);
    }
}

