/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Color;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Colorable;
import org.bukkit.material.MaterialData;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Colour of")
@Description(value={"The <a href='../classes.html#color'>colour</a> of an item, can also be used to colour chat messages with \"&lt;%colour of ...%&gt;this text is coloured!\"."})
@Examples(value={"on click on wool:", "\tmessage \"This wool block is <%colour of block%>%colour of block%<reset>!\"", "\tset the colour of the block to black"})
@Since(value="1.2")
public class ExprColorOf
extends SimplePropertyExpression<Object, Color> {
    boolean changeItemStack = false;

    static {
        ExprColorOf.register(ExprColorOf.class, Color.class, "colo[u]r[s]", "itemstacks/entities");
    }

    @Override
    @Nullable
    public Color convert(Object o) {
        if (o instanceof ItemStack || o instanceof Item) {
            ItemStack is = o instanceof ItemStack ? (ItemStack)o : ((Item)o).getItemStack();
            MaterialData d = is.getData();
            if (d instanceof Colorable) {
                return Color.byWoolColor(((Colorable)d).getColor());
            }
        } else if (o instanceof Colorable) {
            return Color.byWoolColor(((Colorable)o).getColor());
        }
        return null;
    }

    @Override
    protected String getPropertyName() {
        return "colour";
    }

    @Override
    public Class<Color> getReturnType() {
        return Color.class;
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode != Changer.ChangeMode.SET) {
            return null;
        }
        if (Entity.class.isAssignableFrom(this.getExpr().getReturnType())) {
            return CollectionUtils.array(Color.class);
        }
        if (!this.getExpr().isSingle()) {
            return null;
        }
        if (Changer.ChangerUtils.acceptsChange(this.getExpr(), mode, ItemStack.class, ItemType.class)) {
            this.changeItemStack = Changer.ChangerUtils.acceptsChange(this.getExpr(), mode, ItemStack.class);
            return CollectionUtils.array(Color.class);
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        assert (mode == Changer.ChangeMode.SET);
        assert (delta != null);
        Color c = (Color)delta[0];
        F[] os = this.getExpr().getArray(e);
        if (os.length == 0) {
            return;
        }
        F[] FArray = os;
        int n = os.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = FArray[n2];
            if (o instanceof ItemStack || o instanceof Item) {
                ItemStack is = o instanceof ItemStack ? (ItemStack)o : ((Item)o).getItemStack();
                MaterialData d = is.getData();
                if (d instanceof Colorable) {
                    ((Colorable)d).setColor(c.getWoolColor());
                    if (o instanceof ItemStack) {
                        if (this.changeItemStack) {
                            this.getExpr().change(e, new ItemStack[]{is}, mode);
                        } else {
                            this.getExpr().change(e, new ItemType[]{new ItemType(is)}, mode);
                        }
                    } else {
                        ((Item)o).setItemStack(is);
                    }
                }
            } else if (o instanceof Colorable) {
                ((Colorable)o).setColor(c.getWoolColor());
            }
            ++n2;
        }
    }
}

