/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Make Say")
@Description(value={"Forces a player to send a message to the chat. If the message starts with a slash it will force the player to use command."})
@Examples(value={"make the player say \"Hello.\"", "force all players to send the message \"I love this server\""})
@Since(value="2.3")
public class EffMakeSay
extends Effect {
    private Expression<Player> players;
    private Expression<String> messages;

    static {
        Skript.registerEffect(EffMakeSay.class, "make %players% (say|send [the] message[s]) %strings%", "force %players% to (say|send [the] message[s]) %strings%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        this.messages = exprs[1];
        return true;
    }

    @Override
    protected void execute(Event e) {
        Player[] playerArray = this.players.getArray(e);
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            String[] stringArray = this.messages.getArray(e);
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String message = stringArray[n4];
                player.chat(message);
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "make " + this.players.toString(e, debug) + " say " + this.messages.toString(e, debug);
    }
}

