/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.classes.data.DefaultComparators;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Is of Type")
@Description(value={"Checks whether an item of entity is of the given type. This is mostly useful for variables, as you can use the general 'is' condition otherwise (e.g. 'victim is a creeper')."})
@Examples(value={"tool is of type {*selected type}", "victim is of type {villager type}"})
@Since(value="1.4")
public class CondIsOfType
extends Condition {
    private Expression<?> what;
    private Expression<?> types;

    static {
        PropertyCondition.register(CondIsOfType.class, "of type[s] %entitytypes/entitydatas%", "itemstacks/entities");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.what = exprs[0];
        this.types = exprs[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public boolean check(Event e) {
        return this.what.check(e, o1 -> this.types.check(e, o2 -> {
            if (o2 instanceof ItemType && o1 instanceof ItemType) {
                return ((ItemType)o2).isSupertypeOf((ItemType)o1);
            }
            if (o2 instanceof EntityData && o1 instanceof Entity) {
                return ((EntityData)o2).isInstance((Entity)o1);
            }
            if (o2 instanceof ItemType && o1 instanceof Entity) {
                return Comparator.Relation.EQUAL.is(DefaultComparators.entityItemComparator.compare(EntityData.fromEntity((Entity)o1), (ItemType)o2));
            }
            return false;
        }), this.isNegated());
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return PropertyCondition.toString(this, PropertyCondition.PropertyType.BE, e, debug, this.what, "of " + (this.types.isSingle() ? "type " : "types") + this.types.toString(e, debug));
    }
}

