/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.EnchantmentType;
import ch.njol.util.Kleenean;
import java.util.Map;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Is Enchanted")
@Description(value={"Checks whether an item is enchanted."})
@Examples(value={"tool of the player is enchanted with efficiency 2", "helm, chestplate, leggings or boots are enchanted"})
@Since(value="1.4.6")
public class CondIsEnchanted
extends Condition {
    private Expression<ItemType> items;
    @Nullable
    private Expression<EnchantmentType> enchs;

    static {
        PropertyCondition.register(CondIsEnchanted.class, "enchanted [with %-enchantmenttype%]", "itemtypes");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.items = exprs[0];
        this.enchs = exprs[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public boolean check(Event e) {
        return this.items.check(e, item -> {
            Expression<EnchantmentType> enchsExpr = this.enchs;
            if (enchsExpr == null) {
                Map<Enchantment, Integer> enchs = item.getEnchantments();
                return this.isNegated() ^ (enchs != null && !enchs.isEmpty());
            }
            return enchsExpr.check(e, ench -> ench.has((ItemType)item));
        }, this.isNegated());
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        Expression<EnchantmentType> es = this.enchs;
        return PropertyCondition.toString(this, PropertyCondition.PropertyType.BE, e, debug, this.items, "enchanted" + (es == null ? "" : " with " + es.toString(e, debug)));
    }
}

