/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.aliases;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.aliases.AliasesParser;
import ch.njol.skript.aliases.AliasesProvider;
import ch.njol.skript.aliases.ItemData;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.aliases.MaterialName;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.localization.ArgsMessage;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.Message;
import ch.njol.skript.localization.Noun;
import ch.njol.skript.localization.RegexMessage;
import ch.njol.skript.log.BlockingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.util.EnchantmentType;
import ch.njol.skript.util.Utils;
import ch.njol.skript.util.Version;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.eclipse.jdt.annotation.Nullable;

public abstract class Aliases {
    private static final AliasesProvider provider = Aliases.createProvider();
    private static final AliasesParser parser = Aliases.createParser(provider);
    static String itemSingular = "item";
    static String itemPlural = "items";
    @Nullable
    static String itemGender = null;
    static String blockSingular = "block";
    static String blockPlural = "blocks";
    @Nullable
    static String blockGender = null;
    private static final ItemType everything = new ItemType();
    private static final Message m_missing_aliases;
    private static final Message m_empty_string;
    private static final ArgsMessage m_invalid_item_type;
    private static final ArgsMessage m_loaded_x_aliases_from;
    private static final ArgsMessage m_loaded_x_aliases;
    private static final Message m_outside_section;
    private static final Pattern numberWordPattern;
    private static final RegexMessage p_any;
    private static final Message m_any;
    private static final RegexMessage p_every;
    private static final RegexMessage p_of_every;
    private static final RegexMessage p_of;
    private static final Map<String, ItemType> trackedTypes;

    static {
        everything.setAll(true);
        ItemData all = new ItemData(Material.AIR);
        all.isAnything = true;
        everything.add(all);
        m_missing_aliases = new Message("aliases.missing aliases");
        m_empty_string = new Message("aliases.empty string");
        m_invalid_item_type = new ArgsMessage("aliases.invalid item type");
        m_loaded_x_aliases_from = new ArgsMessage("aliases.loaded x aliases from");
        m_loaded_x_aliases = new ArgsMessage("aliases.loaded x aliases");
        m_outside_section = new Message("aliases.outside section");
        numberWordPattern = Pattern.compile("\\d+\\s+.+");
        p_any = new RegexMessage("aliases.any", "", " (.+)", 2);
        m_any = new Message("aliases.any-skp");
        p_every = new RegexMessage("aliases.every", "", " (.+)", 2);
        p_of_every = new RegexMessage("aliases.of every", "(\\d+) ", " (.+)", 2);
        p_of = new RegexMessage("aliases.of", "(\\d+) (?:", " )?(.+)", 2);
        trackedTypes = new HashMap<String, ItemType>();
    }

    @Nullable
    private static ItemType getAlias_i(String s) {
        ItemType t = ScriptLoader.getScriptAliases().get(s);
        if (t != null) {
            return t;
        }
        return provider.getAlias(s);
    }

    private static AliasesProvider createProvider() {
        return new AliasesProvider();
    }

    private static AliasesParser createParser(AliasesProvider provider) {
        AliasesParser parser = new AliasesParser(provider);
        parser.registerCondition("minecraft version", str -> {
            int orNewer = str.indexOf("or newer");
            if (orNewer != -1) {
                Version ver = new Version(str.substring(0, orNewer - 1));
                if (Skript.getMinecraftVersion().compareTo(ver) >= 0) {
                    return true;
                }
                return false;
            }
            int orOlder = str.indexOf("or older");
            if (orOlder != -1) {
                Version ver = new Version(str.substring(0, orOlder - 1));
                if (Skript.getMinecraftVersion().compareTo(ver) <= 0) {
                    return true;
                }
                return false;
            }
            int to = str.indexOf("to");
            if (to != -1) {
                Version first = new Version(str.substring(0, to - 1));
                Version second = new Version(str.substring(to + 3));
                Version current = Skript.getMinecraftVersion();
                if (current.compareTo(first) >= 0 && current.compareTo(second) <= 0) {
                    return true;
                }
                return false;
            }
            return Skript.getMinecraftVersion().equals(new Version((String)str));
        });
        return parser;
    }

    static String concatenate(String ... parts) {
        assert (parts.length >= 2);
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < parts.length) {
            if (!parts[i].isEmpty()) {
                if (b.length() == 0) {
                    b.append(parts[i]);
                } else {
                    char c = parts[i].charAt(0);
                    if (Character.isUpperCase(c) && b.charAt(b.length() - 1) != ' ') {
                        b.append(String.valueOf(Character.toLowerCase(c)) + parts[i].substring(1));
                    } else {
                        b.append(parts[i]);
                    }
                }
            }
            ++i;
        }
        return b.toString().replace("  ", " ").trim();
    }

    public static final String getMaterialName(ItemData type, boolean plural) {
        MaterialName name = provider.getMaterialName(type.aliasCopy());
        if (name == null) {
            return "" + type.type;
        }
        return name.toString(plural);
    }

    public static final int getGender(ItemData item) {
        MaterialName n = provider.getMaterialName(item);
        if (n != null) {
            return n.gender;
        }
        return -1;
    }

    static int addMissingMaterialNames() {
        int r = 0;
        StringBuilder missing = new StringBuilder(m_missing_aliases + " ");
        Material[] materialArray = Material.values();
        int n = materialArray.length;
        int n2 = 0;
        while (n2 < n) {
            Material m = materialArray[n2];
            assert (m != null);
            ItemData data = new ItemData(m);
            if (provider.getMaterialName(data) == null) {
                provider.setMaterialName(data, new MaterialName(m, m.toString().toLowerCase().replace('_', ' '), m.toString().toLowerCase().replace('_', ' '), 0));
                missing.append(String.valueOf(m.getId()) + ", ");
                ++r;
            }
            ++n2;
        }
        if (r > 0) {
            Skript.warning(missing.substring(0, missing.length() - 2));
        }
        return r;
    }

    @Nullable
    public static ItemType parseAlias(String s) {
        String[] types;
        if (s.isEmpty()) {
            Skript.error(m_empty_string.toString());
            return null;
        }
        if (s.equals("*")) {
            return everything;
        }
        ItemType t = new ItemType();
        String[] stringArray = types = s.split("\\s*,\\s*");
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (type == null || Aliases.parseType(type, t, true) == null) {
                return null;
            }
            ++n2;
        }
        return t;
    }

    @Nullable
    public static ItemType parseItemType(String s) {
        if (s.isEmpty()) {
            return null;
        }
        s = s.trim();
        ItemType t = new ItemType();
        Matcher m = p_of_every.matcher(s);
        if (m.matches()) {
            t.setAmount(Utils.parseInt(m.group(1)));
            t.setAll(true);
            s = m.group(m.groupCount());
        } else {
            m = p_of.matcher(s);
            if (m.matches()) {
                t.setAmount(Utils.parseInt(m.group(1)));
                s = m.group(m.groupCount());
            } else {
                m = p_every.matcher(s);
                if (m.matches()) {
                    t.setAll(true);
                    s = m.group(m.groupCount());
                } else {
                    int l = s.length();
                    if ((s = Noun.stripIndefiniteArticle(s)).length() != l) {
                        t.setAmount(1);
                    }
                }
            }
        }
        String lc = s.toLowerCase();
        String of = Language.getSpaced("enchantments.of").toLowerCase();
        int c = -1;
        block3: while ((c = lc.indexOf(of, c + 1)) != -1) {
            String[] enchs;
            ItemType t2 = t.clone();
            BlockingLogHandler log = SkriptLogger.startLogHandler(new BlockingLogHandler());
            try {
                if (Aliases.parseType(s.substring(0, c), t2, false) == null) {
                    continue;
                }
            }
            finally {
                log.stop();
            }
            if (t2.numTypes() == 0) continue;
            HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
            String[] stringArray = enchs = lc.substring(c + of.length(), lc.length()).split("\\s*(,|" + Pattern.quote(Language.get("and")) + ")\\s*");
            int n = enchs.length;
            int n2 = 0;
            while (n2 < n) {
                String ench = stringArray[n2];
                EnchantmentType e = EnchantmentType.parse(ench);
                if (e == null) continue block3;
                enchantments.put(e.getType(), e.getLevel());
                ++n2;
            }
            t2.addEnchantments(enchantments);
            return t2;
        }
        if (Aliases.parseType(s, t, false) == null) {
            return null;
        }
        if (t.numTypes() == 0) {
            return null;
        }
        return t;
    }

    @Nullable
    private static ItemType parseType(String s, ItemType t, boolean isAlias) {
        String type = s;
        if (type.isEmpty()) {
            t.add(new ItemData(Material.AIR));
            return t;
        }
        if (type.matches("\\d+")) {
            Skript.error("Numeric ids are not supported anymore.");
            return null;
        }
        ItemType i = Aliases.getAlias(type);
        if (i != null) {
            for (ItemData d : i) {
                d = d.clone();
                t.add(d);
            }
            return t;
        }
        if (isAlias) {
            Skript.error(m_invalid_item_type.toString(s));
        }
        return null;
    }

    @Nullable
    private static ItemType getAlias(String s) {
        ItemType i;
        String lc = s.toLowerCase();
        Matcher m = p_any.matcher(lc);
        if (m.matches()) {
            lc = m.group(m.groupCount());
        }
        if ((i = Aliases.getAlias_i(lc)) != null) {
            return i.clone();
        }
        boolean b = lc.endsWith(" " + blockSingular);
        if (b || lc.endsWith(" " + blockPlural)) {
            i = Aliases.getAlias_i(s.substring(0, s.length() - (b ? blockSingular.length() : blockPlural.length()) - 1));
            if (i != null) {
                i = i.clone();
                int j = 0;
                while (j < i.numTypes()) {
                    ItemData d = i.getTypes().get(j);
                    if (d.getType().isBlock()) {
                        i.remove(d);
                        --j;
                    }
                    ++j;
                }
                if (i.getTypes().isEmpty()) {
                    return null;
                }
                return i;
            }
        } else {
            b = lc.endsWith(" " + itemSingular);
            if ((b || lc.endsWith(" " + itemPlural)) && (i = Aliases.getAlias_i(s.substring(0, s.length() - (b ? itemSingular.length() : itemPlural.length()) - 1))) != null) {
                int j = 0;
                while (j < i.numTypes()) {
                    ItemData d = i.getTypes().get(j);
                    if (!d.isAnything && d.getType().isBlock()) {
                        i.remove(d);
                        --j;
                    }
                    ++j;
                }
                if (i.getTypes().isEmpty()) {
                    return null;
                }
                return i;
            }
        }
        return null;
    }

    public static void clear() {
        provider.clearAliases();
    }

    public static void load() {
        try {
            long start = System.currentTimeMillis();
            Aliases.loadInternal();
            Skript.info("Loaded " + provider.getAliasCount() + " aliases in " + (System.currentTimeMillis() - start) + "ms");
        }
        catch (IOException e) {
            Skript.exception((Throwable)e, new String[0]);
        }
    }

    private static void loadInternal() throws IOException {
        Path aliasesFolder;
        Path dataFolder;
        block30: {
            dataFolder = Skript.getInstance().getDataFolder().toPath();
            Path zipPath = dataFolder.resolve("aliases-english.zip");
            if (SkriptConfig.loadDefaultAliases.value().booleanValue()) {
                Throwable throwable;
                if (Files.exists(zipPath, new LinkOption[0])) {
                    Throwable throwable2 = null;
                    throwable = null;
                    try (FileSystem zipFs = FileSystems.newFileSystem(zipPath, Skript.class.getClassLoader());){
                        assert (zipFs != null);
                        Path aliasesPath = zipFs.getPath("/", new String[0]);
                        assert (aliasesPath != null);
                        Aliases.loadDirectory(aliasesPath);
                        break block30;
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                try {
                    URI jarUri = Skript.class.getProtectionDomain().getCodeSource().getLocation().toURI();
                    throwable = null;
                    Iterator<Map.Entry<String, ItemType>> iterator = null;
                    try (FileSystem zipFs = FileSystems.newFileSystem(Paths.get(jarUri), Skript.class.getClassLoader());){
                        assert (zipFs != null);
                        Path aliasesPath = zipFs.getPath("/", "aliases-english");
                        assert (aliasesPath != null);
                        Aliases.loadDirectory(aliasesPath);
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (URISyntaxException e) {
                    if ($assertionsDisabled) break block30;
                    throw new AssertionError();
                }
            }
        }
        if (Files.exists(aliasesFolder = dataFolder.resolve("aliases"), new LinkOption[0])) {
            assert (aliasesFolder != null);
            Aliases.loadDirectory(aliasesFolder);
        }
        for (Map.Entry<String, ItemType> entry : trackedTypes.entrySet()) {
            ItemType type = Aliases.parseItemType(entry.getKey());
            if (type == null) {
                Skript.warning("Alias '" + entry.getKey() + "' is required by Skript, but does not exist anymore. " + "Make sure to fix this before restarting the server.");
                continue;
            }
            entry.getValue().setTo(type);
        }
    }

    public static void loadDirectory(Path dir) throws IOException {
        try {
            Files.list(dir).sorted().forEach(f -> {
                assert (f != null);
                try {
                    String name = f.getFileName().toString();
                    if (Files.isDirectory(f, new LinkOption[0]) && !name.startsWith(".")) {
                        Aliases.loadDirectory(f);
                    } else if (name.endsWith(".sk")) {
                        Aliases.load(f);
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public static void load(Path f) throws IOException {
        Config config = new Config(f, false, false, "=");
        Aliases.load(config);
    }

    public static void load(Config config) {
        for (Node n : config.getMainNode()) {
            if (!(n instanceof SectionNode)) {
                Skript.error(m_outside_section.toString());
                continue;
            }
            parser.load((SectionNode)n);
        }
    }

    public static boolean isSupertypeOf(ItemData first, ItemData second) {
        Set<ItemData> subtypes = provider.getSubtypes(first);
        if (subtypes != null) {
            return subtypes.contains(second);
        }
        return false;
    }

    @Nullable
    public static String getMinecraftId(ItemData data) {
        return provider.getMinecraftId(data.aliasCopy());
    }

    public static ItemType javaItemType(String name) {
        ItemType type = Aliases.parseItemType(name);
        if (type == null) {
            throw new IllegalArgumentException("type " + name + " not found");
        }
        trackedTypes.put(name, type);
        return type;
    }

    public static AliasesProvider getAddonProvider(@Nullable SkriptAddon addon) {
        if (addon == null) {
            throw new IllegalArgumentException("addon needed");
        }
        return provider;
    }
}

