/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.variables;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.ExceptionUtils;
import ch.njol.skript.util.FileUtils;
import ch.njol.skript.util.Task;
import ch.njol.skript.util.Utils;
import ch.njol.skript.util.Version;
import ch.njol.skript.variables.SerializedVariable;
import ch.njol.skript.variables.Variables;
import ch.njol.skript.variables.VariablesStorage;
import ch.njol.util.NotifyingReference;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

public class FlatFileStorage
extends VariablesStorage {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    private final NotifyingReference<PrintWriter> changesWriter = new NotifyingReference();
    private volatile boolean loaded = false;
    final AtomicInteger changes = new AtomicInteger(0);
    private final int REQUIRED_CHANGES_FOR_RESAVE = 1000;
    @Nullable
    private Task saveTask;
    private boolean loadError = false;
    private static final Pattern csv = Pattern.compile("(?<=^|,)\\s*([^\",]*|\"([^\"]|\"\")*\")\\s*(,|$)");
    private static final Pattern containsWhitespace = Pattern.compile("\\s");

    protected FlatFileStorage(String name) {
        super(name);
    }

    @Override
    protected boolean load_i(SectionNode n) {
        File file;
        boolean update2_1;
        StringBuilder invalid;
        int unsuccessful;
        IOException ioEx;
        block33: {
            SkriptLogger.setNode(null);
            ioEx = null;
            unsuccessful = 0;
            invalid = new StringBuilder();
            Version varVersion = Skript.getVersion();
            Version v2_0_beta3 = new Version(2, 0, "beta 3");
            boolean update2_0_beta3 = false;
            Version v2_1 = new Version(2, 1);
            update2_1 = false;
            BufferedReader r = null;
            try {
                try {
                    r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), UTF_8));
                    String line = null;
                    int lineNum = 0;
                    while ((line = r.readLine()) != null) {
                        ++lineNum;
                        if ((line = line.trim()).isEmpty() || line.startsWith("#")) {
                            if (!line.startsWith("# version:")) continue;
                            try {
                                varVersion = new Version(line.substring("# version:".length()).trim());
                                update2_0_beta3 = varVersion.isSmallerThan(v2_0_beta3);
                                update2_1 = varVersion.isSmallerThan(v2_1);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {}
                            continue;
                        }
                        String[] split = FlatFileStorage.splitCSV(line);
                        if (split == null || split.length != 3) {
                            Skript.error("invalid amount of commas in line " + lineNum + " ('" + line + "')");
                            if (invalid.length() != 0) {
                                invalid.append(", ");
                            }
                            invalid.append(split == null ? "<unknown>" : split[0]);
                            ++unsuccessful;
                            continue;
                        }
                        if (split[1].equals("null")) {
                            Variables.variableLoaded(split[0], null, this);
                            continue;
                        }
                        Object d = update2_1 ? Classes.deserialize(split[1], split[2]) : Classes.deserialize(split[1], FlatFileStorage.decode(split[2]));
                        if (d == null) {
                            if (invalid.length() != 0) {
                                invalid.append(", ");
                            }
                            invalid.append(split[0]);
                            ++unsuccessful;
                            continue;
                        }
                        if (d instanceof String && update2_0_beta3) {
                            d = Utils.replaceChatStyles((String)d);
                        }
                        Variables.variableLoaded(split[0], d, this);
                    }
                }
                catch (IOException e) {
                    this.loadError = true;
                    ioEx = e;
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block33;
                }
            }
            catch (Throwable throwable) {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if ((file = this.file) == null) {
            assert (false) : this;
            return false;
        }
        if (ioEx != null || unsuccessful > 0 || update2_1) {
            if (unsuccessful > 0) {
                Skript.error(String.valueOf(unsuccessful) + " variable" + (unsuccessful == 1 ? "" : "s") + " could not be loaded!");
                Skript.error("Affected variables: " + invalid.toString());
            }
            if (ioEx != null) {
                Skript.error("An I/O error occurred while loading the variables: " + ExceptionUtils.toString(ioEx));
                Skript.error("This means that some to all variables could not be loaded!");
            }
            try {
                if (update2_1) {
                    Skript.info("[2.1] updating " + file.getName() + " to the new format...");
                }
                File bu = FileUtils.backup(file);
                Skript.info("Created a backup of " + file.getName() + " as " + bu.getName());
                this.loadError = false;
            }
            catch (IOException ex) {
                Skript.error("Could not backup " + file.getName() + ": " + ex.getMessage());
            }
        }
        if (update2_1) {
            this.saveVariables(false);
            Skript.info(String.valueOf(file.getName()) + " successfully updated.");
        }
        this.connect();
        this.saveTask = new Task((Plugin)Skript.getInstance(), 6000L, 6000L, true){

            @Override
            public void run() {
                if (FlatFileStorage.this.changes.get() >= 1000) {
                    try {
                        Variables.getReadLock().lock();
                        FlatFileStorage.this.saveVariables(false);
                        FlatFileStorage.this.changes.set(0);
                    }
                    finally {
                        Variables.getReadLock().unlock();
                    }
                }
            }
        };
        return ioEx == null;
    }

    @Override
    protected void allLoaded() {
    }

    @Override
    protected boolean requiresFile() {
        return true;
    }

    @Override
    protected File getFile(String file) {
        return new File(file);
    }

    static String encode(byte[] data) {
        char[] r = new char[data.length * 2];
        int i = 0;
        while (i < data.length) {
            r[2 * i] = Character.toUpperCase(Character.forDigit((data[i] & 0xF0) >>> 4, 16));
            r[2 * i + 1] = Character.toUpperCase(Character.forDigit(data[i] & 0xF, 16));
            ++i;
        }
        return new String(r);
    }

    static byte[] decode(String hex) {
        byte[] r = new byte[hex.length() / 2];
        int i = 0;
        while (i < r.length) {
            r[i] = (byte)((Character.digit(hex.charAt(2 * i), 16) << 4) + Character.digit(hex.charAt(2 * i + 1), 16));
            ++i;
        }
        return r;
    }

    @Nullable
    static String[] splitCSV(String line) {
        Matcher m = csv.matcher(line);
        int lastEnd = 0;
        ArrayList<String> r = new ArrayList<String>();
        while (m.find()) {
            if (lastEnd != m.start()) {
                return null;
            }
            String v = m.group(1);
            if (v.startsWith("\"")) {
                r.add(v.substring(1, v.length() - 1).replace("\"\"", "\""));
            } else {
                r.add(v.trim());
            }
            lastEnd = m.end();
        }
        if (lastEnd != line.length()) {
            return null;
        }
        return r.toArray(new String[r.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean save(String name, @Nullable String type, @Nullable byte[] value) {
        Object object = this.connectionLock;
        synchronized (object) {
            NotifyingReference<PrintWriter> notifyingReference = this.changesWriter;
            synchronized (notifyingReference) {
                PrintWriter cw;
                if (!this.loaded && type == null) {
                    return true;
                }
                while (true) {
                    block10: {
                        if ((cw = this.changesWriter.get()) == null) break block10;
                    }
                    try {
                        this.changesWriter.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                FlatFileStorage.writeCSV(cw, name, type, value == null ? "" : FlatFileStorage.encode(value));
                cw.flush();
                this.changes.incrementAndGet();
            }
            return true;
        }
    }

    private static void writeCSV(PrintWriter pw, String ... values) {
        assert (values.length == 3);
        int i = 0;
        while (i < values.length) {
            String v;
            if (i != 0) {
                pw.print(", ");
            }
            if ((v = values[i]) != null && (v.contains(",") || v.contains("\"") || v.contains("#") || containsWhitespace.matcher(v).find())) {
                v = String.valueOf('\"') + v.replace("\"", "\"\"") + '\"';
            }
            pw.print(v);
            ++i;
        }
        pw.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void disconnect() {
        Object object = this.connectionLock;
        synchronized (object) {
            this.clearChangesQueue();
            NotifyingReference<PrintWriter> notifyingReference = this.changesWriter;
            synchronized (notifyingReference) {
                PrintWriter cw = this.changesWriter.get();
                if (cw != null) {
                    cw.close();
                    this.changesWriter.set(null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    protected final boolean connect() {
        Object object = this.connectionLock;
        synchronized (object) {
            NotifyingReference<PrintWriter> notifyingReference = this.changesWriter;
            synchronized (notifyingReference) {
                if (this.changesWriter.get() != null) {
                    return true;
                }
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try {
                        FileOutputStream fos = new FileOutputStream(this.file, true);
                        this.changesWriter.set(new PrintWriter(new OutputStreamWriter((OutputStream)fos, UTF_8)));
                        this.loaded = true;
                        return true;
                        finally {
                            if (fos != null) {
                                fos.close();
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    Skript.exception((Throwable)e, new String[0]);
                    return false;
                }
            }
        }
    }

    @Override
    public void close() {
        this.clearChangesQueue();
        super.close();
        this.saveVariables(true);
    }

    /*
     * Exception decompiling
     */
    public final void saveVariables(boolean finalSave) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void save(PrintWriter pw, String parent, TreeMap<String, Object> map) {
        block0: for (Map.Entry<String, Object> e : map.entrySet()) {
            Object val = e.getValue();
            if (val == null) continue;
            if (val instanceof TreeMap) {
                this.save(pw, String.valueOf(parent) + e.getKey() + "::", (TreeMap)val);
                continue;
            }
            String name = e.getKey() == null ? parent.substring(0, parent.length() - "::".length()) : String.valueOf(parent) + e.getKey();
            for (VariablesStorage s : Variables.storages) {
                SerializedVariable.Value value;
                if (!s.accept(name)) continue;
                if (s != this || (value = Classes.serialize(val)) == null) continue block0;
                FlatFileStorage.writeCSV(pw, name, value.type, FlatFileStorage.encode(value.data));
                continue block0;
            }
        }
    }
}

