/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Skript;
import ch.njol.util.Closeable;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

public abstract class Task
implements Runnable,
Closeable {
    private final Plugin plugin;
    private final boolean async;
    private long period = -1L;
    private int taskID = -1;

    public Task(Plugin plugin, long delay, long period) {
        this(plugin, delay, period, false);
    }

    public Task(Plugin plugin, long delay, long period, boolean async) {
        this.plugin = plugin;
        this.period = period;
        this.async = async;
        this.schedule(delay);
    }

    public Task(Plugin plugin, long delay) {
        this(plugin, delay, false);
    }

    public Task(Plugin plugin, long delay, boolean async) {
        this.plugin = plugin;
        this.async = async;
        this.schedule(delay);
    }

    private void schedule(long delay) {
        assert (!this.isAlive());
        this.taskID = this.period == -1L ? (this.async ? (Skript.isRunningMinecraft(1, 4, 6) ? Bukkit.getScheduler().runTaskLaterAsynchronously(this.plugin, (Runnable)this, delay).getTaskId() : Bukkit.getScheduler().scheduleAsyncDelayedTask(this.plugin, (Runnable)this, delay)) : Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, (Runnable)this, delay)) : (this.async ? (Skript.isRunningMinecraft(1, 4, 6) ? Bukkit.getScheduler().runTaskTimerAsynchronously(this.plugin, (Runnable)this, delay, this.period).getTaskId() : Bukkit.getScheduler().scheduleAsyncRepeatingTask(this.plugin, (Runnable)this, delay, this.period)) : Bukkit.getScheduler().scheduleSyncRepeatingTask(this.plugin, (Runnable)this, delay, this.period));
        assert (this.taskID != -1);
    }

    public final boolean isAlive() {
        if (this.taskID == -1) {
            return false;
        }
        return Bukkit.getScheduler().isQueued(this.taskID) || Bukkit.getScheduler().isCurrentlyRunning(this.taskID);
    }

    public final void cancel() {
        if (this.taskID != -1) {
            Bukkit.getScheduler().cancelTask(this.taskID);
            this.taskID = -1;
        }
    }

    @Override
    public void close() {
        this.cancel();
    }

    public void setNextExecution(long delay) {
        assert (delay >= 0L);
        this.cancel();
        this.schedule(delay);
    }

    public void setPeriod(long period) {
        assert (period == -1L || period > 0L);
        if (period == this.period) {
            return;
        }
        this.period = period;
        if (this.isAlive()) {
            this.cancel();
            if (period != -1L) {
                this.schedule(period);
            }
        }
    }

    @Nullable
    public static <T> T callSync(Callable<T> c) {
        return Task.callSync(c, (Plugin)Skript.getInstance());
    }

    @Nullable
    public static <T> T callSync(Callable<T> c, Plugin p) {
        if (Bukkit.isPrimaryThread()) {
            try {
                return c.call();
            }
            catch (Exception e) {
                Skript.exception((Throwable)e, new String[0]);
            }
        }
        Future f = Bukkit.getScheduler().callSyncMethod(p, c);
        try {
            while (true) {
                try {
                    return (T)f.get();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        catch (ExecutionException e) {
            Skript.exception((Throwable)e, new String[0]);
        }
        catch (CancellationException cancellationException) {
        }
        catch (ThreadDeath threadDeath) {
            // empty catch block
        }
        return null;
    }
}

