/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.classes.Arithmetic;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Comparators;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.StringMode;
import ch.njol.skript.util.Utils;
import ch.njol.skript.variables.TypeHints;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import ch.njol.util.Pair;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import ch.njol.util.coll.iterator.EmptyIterator;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class Variable<T>
implements Expression<T> {
    public static final String SEPARATOR = "::";
    public static final String LOCAL_VARIABLE_TOKEN = "_";
    private final VariableString name;
    private final Class<T> superType;
    final Class<? extends T>[] types;
    final boolean local;
    private final boolean list;
    @Nullable
    private final Variable<?> source;
    private static final boolean uuidSupported = Skript.methodExists(OfflinePlayer.class, "getUniqueId", new Class[0]);

    private Variable(VariableString name, Class<? extends T>[] types, boolean local, boolean list, @Nullable Variable<?> source) {
        assert (name != null);
        assert (types != null && types.length > 0);
        assert (name.isSimple() || name.getMode() == StringMode.VARIABLE_NAME);
        this.local = local;
        this.list = list;
        this.name = name;
        this.types = types;
        this.superType = Utils.getSuperType(types);
        this.source = source;
    }

    public static boolean isValidVariableName(String name, boolean allowListVariable, boolean printErrors) {
        String string = name = name.startsWith(LOCAL_VARIABLE_TOKEN) ? name.substring(LOCAL_VARIABLE_TOKEN.length()).trim() : name.trim();
        if (!allowListVariable && name.contains(SEPARATOR)) {
            if (printErrors) {
                Skript.error("List variables are not allowed here (error in variable {" + name + "})");
            }
            return false;
        }
        if (name.startsWith(SEPARATOR) || name.endsWith(SEPARATOR)) {
            if (printErrors) {
                Skript.error("A variable's name must neither start nor end with the separator '::' (error in variable {" + name + "})");
            }
            return false;
        }
        if (!(!name.contains("*") || allowListVariable && name.indexOf("*") == name.length() - 1 && name.endsWith("::*"))) {
            if (printErrors) {
                if (name.indexOf("*") == 0) {
                    Skript.error("[2.0] Local variables now start with an underscore, e.g. {_local variable}. The asterisk is reserved for list variables. (error in variable {" + name + "})");
                } else {
                    Skript.error("A variable's name must not contain any asterisks except at the end after '::' to denote a list variable, e.g. {variable::*} (error in variable {" + name + "})");
                }
            }
            return false;
        }
        if (name.contains("::::")) {
            if (printErrors) {
                Skript.error("A variable's name must not contain the separator '::' multiple times in a row (error in variable {" + name + "})");
            }
            return false;
        }
        return true;
    }

    @Nullable
    public static <T> Variable<T> newInstance(String name, Class<? extends T>[] types) {
        Class<String> hint;
        if (!Variable.isValidVariableName(name = name.trim(), true, true)) {
            return null;
        }
        VariableString vs = VariableString.newInstance(name.startsWith(LOCAL_VARIABLE_TOKEN) ? name.substring(LOCAL_VARIABLE_TOKEN.length()).trim() : name, StringMode.VARIABLE_NAME);
        if (vs == null) {
            return null;
        }
        boolean isLocal = name.startsWith(LOCAL_VARIABLE_TOKEN);
        boolean isPlural = name.endsWith("::*");
        if (isLocal && vs.isSimple() && (hint = TypeHints.get(vs.toString())) != null && !hint.equals(Object.class)) {
            Class<T> type;
            Class<? extends T>[] classArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                type = classArray[n2];
                assert (type != null);
                if (type.isAssignableFrom(hint)) {
                    return new Variable<T>(vs, CollectionUtils.array(type), isLocal, isPlural, null);
                }
                ++n2;
            }
            classArray = types;
            n = types.length;
            n2 = 0;
            while (n2 < n) {
                type = classArray[n2];
                assert (type != null);
                if (Converters.converterExists(hint, type)) {
                    return new Variable<T>(vs, CollectionUtils.array(type), isLocal, isPlural, null);
                }
                if (type.isAssignableFrom(World.class) && hint.isAssignableFrom(String.class)) {
                    return new Variable<T>(vs, types, isLocal, isPlural, null);
                }
                if (type.isAssignableFrom(Player.class) && hint.isAssignableFrom(String.class)) {
                    return new Variable<T>(vs, types, isLocal, isPlural, null);
                }
                ++n2;
            }
            Object[] infos = new ClassInfo[types.length];
            int i = 0;
            while (i < types.length) {
                infos[i] = Classes.getExactClassInfo(types[i]);
                ++i;
            }
            Skript.warning("Local variable '" + name + "' is " + Classes.toString(Classes.getExactClassInfo(hint)) + ", not " + Classes.toString(infos, false));
        }
        return new Variable<T>(vs, types, isLocal, isPlural, null);
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        throw new UnsupportedOperationException();
    }

    public boolean isLocal() {
        return this.local;
    }

    public boolean isList() {
        return this.list;
    }

    @Override
    public boolean isSingle() {
        return !this.list;
    }

    @Override
    public Class<? extends T> getReturnType() {
        return this.superType;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (e != null) {
            return Classes.toString(this.get(e));
        }
        return "{" + (this.local ? LOCAL_VARIABLE_TOKEN : "") + StringUtils.substring(this.name.toString(e, debug), 1, -1) + "}" + (debug ? "(as " + this.superType.getName() + ")" : "");
    }

    @Override
    public String toString() {
        return this.toString(null, false);
    }

    @Override
    public <R> Variable<R> getConvertedExpression(Class<R> ... to) {
        return new Variable<R>(this.name, to, this.local, this.list, this);
    }

    @Nullable
    private Object getRaw(Event e) {
        Object val;
        String n = this.name.toString(e);
        if (n.endsWith("::*") != this.list) {
            return null;
        }
        Object object = val = !this.list ? this.convertIfOldPlayer(n, e, Variables.getVariable(n, e, this.local)) : Variables.getVariable(n, e, this.local);
        if (val == null) {
            return Variables.getVariable(String.valueOf(this.local ? LOCAL_VARIABLE_TOKEN : "") + this.name.getDefaultVariableName(), e, false);
        }
        return val;
    }

    @Nullable
    private Object get(Event e) {
        Object val = this.getRaw(e);
        if (!this.list) {
            return val;
        }
        if (val == null) {
            return Array.newInstance(this.types[0], 0);
        }
        ArrayList<Object> l = new ArrayList<Object>();
        String name = StringUtils.substring(this.name.toString(e), 0, -1);
        for (Map.Entry v : ((Map)val).entrySet()) {
            if (v.getKey() == null || v.getValue() == null) continue;
            Object o = v.getValue() instanceof Map ? ((Map)v.getValue()).get(null) : v.getValue();
            l.add(this.convertIfOldPlayer(String.valueOf(name) + (String)v.getKey(), e, o));
        }
        return l.toArray();
    }

    @Nullable
    Object convertIfOldPlayer(String key, Event event, @Nullable Object t) {
        Player p;
        if (SkriptConfig.enablePlayerVariableFix.value().booleanValue() && t != null && t instanceof Player && !(p = (Player)t).isValid() && p.isOnline()) {
            Player player = uuidSupported ? Bukkit.getPlayer((UUID)p.getUniqueId()) : Bukkit.getPlayerExact((String)p.getName());
            Variables.setVariable(key, player, event, this.local);
            return player;
        }
        return t;
    }

    public Iterator<Pair<String, Object>> variablesIterator(final Event e) {
        if (!this.list) {
            throw new SkriptAPIException("Looping a non-list variable");
        }
        final String name = StringUtils.substring(this.name.toString(e), 0, -1);
        Object val = Variables.getVariable(String.valueOf(name) + "*", e, this.local);
        if (val == null) {
            return new EmptyIterator<Pair<String, Object>>();
        }
        assert (val instanceof TreeMap);
        final Iterator keys = new ArrayList(((Map)val).keySet()).iterator();
        return new Iterator<Pair<String, Object>>(){
            @Nullable
            private String key;
            @Nullable
            private Object next = null;

            /*
             * Unable to fully structure code
             */
            @Override
            public boolean hasNext() {
                if (this.next == null) ** GOTO lbl8
                return true;
lbl-1000:
                // 1 sources

                {
                    this.key = (String)keys.next();
                    if (this.key == null) continue;
                    this.next = Variable.this.convertIfOldPlayer(String.valueOf(name) + this.key, e, Variables.getVariable(String.valueOf(name) + this.key, e, Variable.this.local));
                    if (this.next == null || this.next instanceof TreeMap) continue;
                    return true;
lbl8:
                    // 3 sources

                    ** while (keys.hasNext())
                }
lbl9:
                // 1 sources

                this.next = null;
                return false;
            }

            @Override
            public Pair<String, Object> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Pair<String, Object> n = new Pair<String, Object>(this.key, this.next);
                this.next = null;
                return n;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterator<T> iterator(final Event e) {
        if (!this.list) {
            throw new SkriptAPIException("");
        }
        final String name = StringUtils.substring(this.name.toString(e), 0, -1);
        Object val = Variables.getVariable(String.valueOf(name) + "*", e, this.local);
        if (val == null) {
            return new EmptyIterator();
        }
        assert (val instanceof TreeMap);
        final Iterator keys = new ArrayList(((Map)val).keySet()).iterator();
        return new Iterator<T>(){
            @Nullable
            private String key;
            @Nullable
            private T next = null;

            /*
             * Unable to fully structure code
             */
            @Override
            public boolean hasNext() {
                if (this.next == null) ** GOTO lbl9
                return true;
lbl-1000:
                // 1 sources

                {
                    this.key = (String)keys.next();
                    if (this.key == null) continue;
                    this.next = Converters.convert(Variables.getVariable(String.valueOf(name) + this.key, e, Variable.this.local), Variable.this.types);
                    this.next = Variable.this.convertIfOldPlayer(String.valueOf(name) + this.key, e, this.next);
                    if (this.next == null || this.next instanceof TreeMap) continue;
                    return true;
lbl9:
                    // 3 sources

                    ** while (keys.hasNext())
                }
lbl10:
                // 1 sources

                this.next = null;
                return false;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object n = this.next;
                if (!$assertionsDisabled && n == null) {
                    throw new AssertionError();
                }
                this.next = null;
                return n;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Nullable
    private T getConverted(Event e) {
        assert (!this.list);
        return Converters.convert(this.get(e), this.types);
    }

    private T[] getConvertedArray(Event e) {
        assert (this.list);
        return Converters.convertArray((Object[])this.get(e), this.types, this.superType);
    }

    private final void set(Event e, @Nullable Object value) {
        Variables.setVariable(this.name.toString(e), value, e, this.local);
    }

    private final void setIndex(Event e, String index, @Nullable Object value) {
        assert (this.list);
        String s = this.name.toString(e);
        assert (s.endsWith("::*")) : String.valueOf(s) + "; " + this.name;
        Variables.setVariable(String.valueOf(s.substring(0, s.length() - 1)) + index, value, e, this.local);
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (!this.list && mode == Changer.ChangeMode.SET) {
            return CollectionUtils.array(Object.class);
        }
        return CollectionUtils.array(Object[].class);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        switch (mode) {
            case DELETE: {
                if (this.list) {
                    ArrayList<String> rem = new ArrayList<String>();
                    Map map = (Map)this.getRaw(e);
                    if (map == null) {
                        return;
                    }
                    for (Map.Entry i : map.entrySet()) {
                        if (i.getKey() == null) continue;
                        rem.add((String)i.getKey());
                    }
                    for (String r : rem) {
                        assert (r != null);
                        this.setIndex(e, r, null);
                    }
                }
                this.set(e, null);
                break;
            }
            case SET: {
                assert (delta != null);
                if (this.list) {
                    this.set(e, null);
                    int i = 1;
                    Object[] objectArray = delta;
                    int n = delta.length;
                    int r = 0;
                    while (r < n) {
                        Object object = objectArray[r];
                        if (object instanceof Object[]) {
                            int j = 0;
                            while (j < ((Object[])object).length) {
                                this.setIndex(e, i + SEPARATOR + j, ((Object[])object)[j]);
                                ++j;
                            }
                        } else {
                            this.setIndex(e, "" + i, object);
                        }
                        ++i;
                        ++r;
                    }
                    break;
                }
                if (delta[0] instanceof Location) {
                    this.set(e, ((Location)delta[0]).clone());
                    break;
                }
                this.set(e, delta[0]);
                break;
            }
            case RESET: {
                Object x = this.getRaw(e);
                if (x == null) {
                    return;
                }
                for (Object v : x instanceof Map ? ((Map)x).values() : Arrays.asList(x)) {
                    Class<?> c = v.getClass();
                    assert (c != null);
                    ClassInfo<?> ci2 = Classes.getSuperClassInfo(c);
                    Changer<?> changer = ci2.getChanger();
                    if (changer == null || changer.acceptChange(Changer.ChangeMode.RESET) == null) continue;
                    Object[] one = (Object[])Array.newInstance(v.getClass(), 1);
                    one[0] = v;
                    changer.change(one, null, Changer.ChangeMode.RESET);
                }
                break;
            }
            case ADD: 
            case REMOVE: 
            case REMOVE_ALL: {
                Class<?>[] cs;
                ClassInfo<?> ci;
                assert (delta != null);
                if (this.list) {
                    Map map = (Map)this.getRaw(e);
                    if (mode == Changer.ChangeMode.REMOVE) {
                        if (map == null) {
                            return;
                        }
                        ArrayList<String> rem = new ArrayList<String>();
                        Object[] one = delta;
                        int changer = delta.length;
                        int ci2 = 0;
                        while (ci2 < changer) {
                            Object d = one[ci2];
                            for (Map.Entry i2 : map.entrySet()) {
                                String key;
                                if (!Comparator.Relation.EQUAL.is(Comparators.compare(i2.getValue(), d)) || (key = (String)i2.getKey()) == null) continue;
                                rem.add(key);
                                break;
                            }
                            ++ci2;
                        }
                        for (String r : rem) {
                            assert (r != null);
                            this.setIndex(e, r, null);
                        }
                    } else if (mode == Changer.ChangeMode.REMOVE_ALL) {
                        if (map == null) {
                            return;
                        }
                        ArrayList<String> rem = new ArrayList<String>();
                        for (Map.Entry i : map.entrySet()) {
                            Object[] objectArray = delta;
                            int i2 = delta.length;
                            int one = 0;
                            while (one < i2) {
                                Object d = objectArray[one];
                                if (Comparator.Relation.EQUAL.is(Comparators.compare(i.getValue(), d))) {
                                    rem.add((String)i.getKey());
                                }
                                ++one;
                            }
                        }
                        for (String r : rem) {
                            assert (r != null);
                            this.setIndex(e, r, null);
                        }
                    } else {
                        assert (mode == Changer.ChangeMode.ADD);
                        int i = 1;
                        Object[] one = delta;
                        int d = delta.length;
                        int ci2 = 0;
                        while (ci2 < d) {
                            Object d2 = one[ci2];
                            if (map != null) {
                                while (map.containsKey("" + i)) {
                                    ++i;
                                }
                            }
                            this.setIndex(e, "" + i, d2);
                            ++i;
                            ++ci2;
                        }
                    }
                    break;
                }
                Object object = this.get(e);
                if (object == null) {
                    ci = null;
                } else {
                    Class<?> c = object.getClass();
                    assert (c != null);
                    ci = Classes.getSuperClassInfo(c);
                }
                Arithmetic<?, ?> a = null;
                if (object == null || ci == null || (a = ci.getMath()) != null) {
                    void var5_12;
                    boolean changed = false;
                    Object[] objectArray = delta;
                    int key = delta.length;
                    int n = 0;
                    while (n < key) {
                        Object d = objectArray[n];
                        if (var5_12 == null || ci == null) {
                            Class<?> c = d.getClass();
                            assert (c != null);
                            ci = Classes.getSuperClassInfo(c);
                            if (ci.getMath() != null || d instanceof Number) {
                                Object object2 = d;
                            }
                            changed = true;
                        } else {
                            Class<?> r = ci.getMathRelativeType();
                            assert (a != null && r != null) : ci;
                            Object diff = Converters.convert(d, r);
                            if (diff != null) {
                                if (mode == Changer.ChangeMode.ADD) {
                                    void var5_14 = a.add(var5_12, diff);
                                } else {
                                    void var5_15 = a.subtract(var5_12, diff);
                                }
                                changed = true;
                            }
                        }
                        ++n;
                    }
                    if (!changed) break;
                    this.set(e, var5_12);
                    break;
                }
                Changer<?> changer = ci.getChanger();
                if (changer == null || (cs = changer.acceptChange(mode)) == null) break;
                Object[] one = (Object[])Array.newInstance(object.getClass(), 1);
                one[0] = object;
                Class[] cs2 = new Class[cs.length];
                int i = 0;
                while (i < cs.length) {
                    cs2[i] = cs[i].isArray() ? cs[i].getComponentType() : cs[i];
                    ++i;
                }
                ArrayList l = new ArrayList();
                Object[] objectArray = delta;
                int n = delta.length;
                int n2 = 0;
                while (n2 < n) {
                    Object d = objectArray[n2];
                    Object d2 = Converters.convert(d, cs2);
                    if (d2 != null) {
                        l.add(d2);
                    }
                    ++n2;
                }
                Changer.ChangerUtils.change(changer, one, l.toArray(), mode);
            }
        }
    }

    @Override
    @Nullable
    public T getSingle(Event e) {
        if (this.list) {
            throw new SkriptAPIException("Invalid call to getSingle");
        }
        return this.getConverted(e);
    }

    @Override
    public T[] getArray(Event e) {
        return this.getAll(e);
    }

    @Override
    public T[] getAll(Event e) {
        if (this.list) {
            return this.getConvertedArray(e);
        }
        T o = this.getConverted(e);
        if (o == null) {
            Object[] r = (Object[])Array.newInstance(this.superType, 0);
            assert (r != null);
            return r;
        }
        Object[] one = (Object[])Array.newInstance(this.superType, 1);
        one[0] = o;
        return one;
    }

    @Override
    public boolean isLoopOf(String s) {
        return s.equalsIgnoreCase("var") || s.equalsIgnoreCase("variable") || s.equalsIgnoreCase("value") || s.equalsIgnoreCase("index");
    }

    public boolean isIndexLoop(String s) {
        return s.equalsIgnoreCase("index");
    }

    @Override
    public boolean check(Event e, Checker<? super T> c, boolean negated) {
        return SimpleExpression.check(this.getAll(e), c, negated, this.getAnd());
    }

    @Override
    public boolean check(Event e, Checker<? super T> c) {
        return SimpleExpression.check(this.getAll(e), c, false, this.getAnd());
    }

    public VariableString getName() {
        return this.name;
    }

    @Override
    public boolean getAnd() {
        return true;
    }

    @Override
    public boolean setTime(int time) {
        return false;
    }

    @Override
    public int getTime() {
        return 0;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public Expression<?> getSource() {
        Variable<?> s = this.source;
        return s == null ? this : s;
    }

    @Override
    public Expression<? extends T> simplify() {
        return this;
    }
}

