/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.EffDrop;
import ch.njol.skript.effects.EffShoot;
import ch.njol.skript.effects.EffSpawn;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.lang.reflect.Array;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Last Spawned Entity")
@Description(value={"Holds the entity that was spawned most recently with the <a href='../effects.html#EffSpawn'>spawn effect</a>, drop with the <a href='../effects/#EffDrop'>drop effect</a> or shot with the <a href='../effects/#EffShoot'>shoot effect</a>. Please note that even though you can spawn multiple mobs simultaneously (e.g. with 'spawn 5 creepers'), only the last spawned mob is saved and can be used. If you spawn an entity, shoot a projectile and drop a item you can however access all them together."})
@Examples(value={"spawn a priest", "set {%spawned priest%.healer} to true", "shoot an arrow from the last spawned entity", "ignite the shot projectile", "drop a diamond sword", "push last dropped item upwards"})
@Since(value="1.3 (spawned entity), 2.0 (shot entity), 2.2-dev26 (dropped item)")
public class ExprLastSpawnedEntity
extends SimpleExpression<Entity> {
    int from;
    private EntityData<?> type;

    static {
        Skript.registerExpression(ExprLastSpawnedEntity.class, Entity.class, ExpressionType.SIMPLE, "[the] [last[ly]] (0\u00a6spawned|1\u00a6shot) %*entitydata%", "[the] [last[ly]] dropped (2\u00a6item)");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.type = parseResult.mark == 2 ? EntityData.fromClass(Item.class) : (EntityData)((Literal)exprs[0]).getSingle();
        this.from = parseResult.mark;
        return true;
    }

    @Nullable
    protected Entity[] get(Event e) {
        Entity en;
        Entity entity = this.from == 0 ? EffSpawn.lastSpawned : (en = this.from == 1 ? EffShoot.lastSpawned : EffDrop.lastSpawned);
        if (en == null) {
            return null;
        }
        if (!this.type.isInstance(en)) {
            return null;
        }
        Entity[] one = (Entity[])Array.newInstance(this.type.getType(), 1);
        one[0] = en;
        return one;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Entity> getReturnType() {
        return this.type.getType();
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the last " + (this.from == 1 ? "spawned" : (this.from == 1 ? "shot" : "dropped")) + " " + this.type;
    }
}

