/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerLoginEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="IP")
@Description(value={"The IP address in a <a href='events.html#connect'>connect</a> event."})
@Examples(value={"on connect:", "log \"[%now%] %IP% joined the server.\""})
@Since(value="INSERT VERSION")
public class ExprIP
extends SimpleExpression<String> {
    static {
        Skript.registerExpression(ExprIP.class, String.class, ExpressionType.SIMPLE, "[the] IP[(-| )address]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!ScriptLoader.isCurrentEvent(PlayerLoginEvent.class)) {
            Skript.error("The 'IP' expression can only be used in a connect event.");
            return false;
        }
        return true;
    }

    @Nullable
    protected String[] get(Event e) {
        return CollectionUtils.array(((PlayerLoginEvent)e).getAddress().toString());
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the ip";
    }
}

