/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.material.Directional;
import org.bukkit.material.MaterialData;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Facing")
@Description(value={"The facing of an entity or block, i.e. exactly north, south, east, west, up or down (unlike <a href='#ExprDirection'>direction</a> which is the exact direction, e.g. '0.5 south and 0.7 east')"})
@Examples(value={"# makes a bridge", "loop blocks from the block below the player in the horizontal facing of the player:", "\tset block to cobblestone"})
@Since(value="1.4")
public class ExprFacing
extends SimplePropertyExpression<Object, Direction> {
    private boolean horizontal;

    static {
        ExprFacing.register(ExprFacing.class, Direction.class, "(1\u00a6horizontal|) facing", "livingentities/blocks");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.horizontal = parseResult.mark == 1;
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Override
    @Nullable
    public Direction convert(Object o) {
        if (o instanceof Block) {
            MaterialData d = ((Block)o).getType().getNewData(((Block)o).getData());
            if (d instanceof Directional) {
                return new Direction(((Directional)d).getFacing(), 1.0);
            }
            return null;
        }
        if (o instanceof LivingEntity) {
            return new Direction(Direction.getFacing(((LivingEntity)o).getLocation(), this.horizontal), 1.0);
        }
        assert (false);
        return null;
    }

    @Override
    protected String getPropertyName() {
        return String.valueOf(this.horizontal ? "horizontal " : "") + "facing";
    }

    @Override
    public Class<Direction> getReturnType() {
        return Direction.class;
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (!Block.class.isAssignableFrom(this.getExpr().getReturnType())) {
            return null;
        }
        if (mode == Changer.ChangeMode.SET) {
            return CollectionUtils.array(Direction.class);
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        assert (mode == Changer.ChangeMode.SET);
        assert (delta != null);
        Block b = (Block)this.getExpr().getSingle(e);
        if (b == null) {
            return;
        }
        MaterialData d = b.getType().getNewData(b.getData());
        if (!(d instanceof Directional)) {
            return;
        }
        ((Directional)d).setFacingDirection(ExprFacing.toBlockFace(((Direction)delta[0]).getDirection(b)));
    }

    private static BlockFace toBlockFace(Vector dir) {
        BlockFace r = null;
        double d = Double.MAX_VALUE;
        BlockFace[] blockFaceArray = BlockFace.values();
        int n = blockFaceArray.length;
        int n2 = 0;
        while (n2 < n) {
            BlockFace f = blockFaceArray[n2];
            double a = Math.pow((double)f.getModX() - dir.getX(), 2.0) + Math.pow((double)f.getModY() - dir.getY(), 2.0) + Math.pow((double)f.getModZ() - dir.getZ(), 2.0);
            if (a < d) {
                d = a;
                r = f;
            }
            ++n2;
        }
        assert (r != null);
        return r;
    }
}

