/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.EnchantmentType;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Item Enchantments")
@Description(value={"All the enchantments an <a href='classes.html#itemtype>item type</a> has."})
@Examples(value={"clear enchantments of event-item"})
@Since(value="2.2-dev36")
public class ExprEnchantments
extends SimpleExpression<EnchantmentType> {
    private Expression<ItemType> items;

    static {
        PropertyExpression.register(ExprEnchantments.class, EnchantmentType.class, "enchantments", "itemtypes");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.items = exprs[0];
        return true;
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Nullable
    protected EnchantmentType[] get(Event e) {
        ArrayList<EnchantmentType> enchantments = new ArrayList<EnchantmentType>();
        ItemType[] itemTypeArray = this.items.getArray(e);
        int n = itemTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemType item = itemTypeArray[n2];
            Map<Enchantment, Integer> enchants = item.getEnchantments();
            if (enchants != null) {
                for (Map.Entry<Enchantment, Integer> enchant : enchants.entrySet()) {
                    enchantments.add(new EnchantmentType(enchant.getKey(), enchant.getValue()));
                }
            }
            ++n2;
        }
        return enchantments.toArray(new EnchantmentType[enchantments.size()]);
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return CollectionUtils.array(EnchantmentType[].class, Enchantment[].class);
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        ItemType[] source = this.items.getArray(e);
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
        if (mode != Changer.ChangeMode.DELETE || mode != Changer.ChangeMode.RESET) {
            assert (delta != null);
            Object[] objectArray = delta;
            int n = delta.length;
            int n2 = 0;
            while (n2 < n) {
                Object enchant2 = objectArray[n2];
                if (enchant2 instanceof EnchantmentType) {
                    EnchantmentType enchantment = (EnchantmentType)enchant2;
                    if (enchantment.getType() != null) {
                        enchantments.put(enchantment.getType(), enchantment.getLevel());
                    }
                } else {
                    enchantments.put((Enchantment)enchant2, -1);
                }
                ++n2;
            }
            if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD) {
                enchantments.replaceAll((enchant, level) -> level == -1 ? 1 : level);
            }
        }
        switch (mode) {
            case ADD: {
                ExprEnchantments.changeEnchantments(item -> item.addEnchantments(enchantments), source);
                break;
            }
            case REMOVE: 
            case REMOVE_ALL: {
                ExprEnchantments.changeEnchantments(item -> {
                    Map<Enchantment, Integer> enchants = item.getEnchantments();
                    assert (enchants != null);
                    enchantments.forEach((enchant, level) -> {
                        if (level == -1) {
                            enchants.remove(enchant);
                        } else {
                            enchants.remove(enchant, level);
                        }
                    });
                    item.clearEnchantments();
                    item.addEnchantments(enchants);
                }, source);
                break;
            }
            case SET: {
                ExprEnchantments.changeEnchantments(item -> {
                    item.clearEnchantments();
                    item.addEnchantments(enchantments);
                }, source);
                break;
            }
            case DELETE: 
            case RESET: {
                ExprEnchantments.changeEnchantments(ItemType::clearEnchantments, source);
            }
        }
    }

    @Override
    public Class<? extends EnchantmentType> getReturnType() {
        return EnchantmentType.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.format("the enchantments of %s", this.items.toString(e, debug));
    }

    private static void changeEnchantments(Consumer<ItemType> consumer, ItemType ... items) {
        ItemType[] itemTypeArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            ItemType item = itemTypeArray[n2];
            consumer.accept(item);
            ++n2;
        }
    }
}

