/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Chunk")
@Description(value={"The <a href='../classes.html#chunk'>chunk</a> a block, location or entity is in"})
@Examples(value={"add the chunk at the player to {protected chunks::*}"})
@Since(value="2.0")
public class ExprChunk
extends PropertyExpression<Location, Chunk> {
    private Expression<Location> locations;

    static {
        Skript.registerExpression(ExprChunk.class, Chunk.class, ExpressionType.PROPERTY, "[the] chunk[s] (of|%-directions%) %locations%", "%locations%'[s] chunk[s]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (matchedPattern == 0) {
            this.locations = exprs[1];
            if (exprs[0] != null) {
                this.locations = Direction.combine(exprs[0], this.locations);
            }
        } else {
            this.locations = exprs[0];
        }
        this.setExpr(this.locations);
        return true;
    }

    protected Chunk[] get(Event e, Location[] source) {
        return this.get(source, new Converter<Location, Chunk>(){

            @Override
            public Chunk convert(Location l) {
                return l.getChunk();
            }
        });
    }

    @Override
    public Class<? extends Chunk> getReturnType() {
        return Chunk.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the chunk at " + this.locations.toString(e, debug);
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.RESET) {
            return new Class[0];
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Chunk[] cs;
        assert (mode == Changer.ChangeMode.RESET);
        Chunk[] chunkArray = cs = (Chunk[])this.getArray(e);
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            Chunk c = chunkArray[n2];
            c.getWorld().regenerateChunk(c.getX(), c.getZ());
            ++n2;
        }
    }
}

