/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.classes.data.DefaultComparators;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Checker;
import org.bukkit.entity.Hanging;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.hanging.HangingEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.eclipse.jdt.annotation.Nullable;

public class EvtBlock
extends SkriptEvent {
    @Nullable
    private Literal<ItemType> types;
    private boolean mine = false;

    static {
        Skript.registerEvent("Break / Mine", EvtBlock.class, new Class[]{BlockBreakEvent.class, PlayerBucketFillEvent.class, Skript.isRunningMinecraft(1, 4, 3) ? HangingBreakEvent.class : HangingBreakEvent.class}, "[block] (break[ing]|1\u00a6min(e|ing)) [[of] %itemtypes%]").description("Called when a block is broken by a player. If you use 'on mine', only events where the broken block dropped something will call the trigger.").examples("on mine", "on break of stone", "on mine of any ore").since("1.0 (break), <i>unknown</i> (mine)");
        Skript.registerEvent("Burn", EvtBlock.class, BlockBurnEvent.class, "[block] burn[ing] [[of] %itemtypes%]").description("Called when a block is destroyed by fire.").examples("on burn", "on burn of wood, fences, or chests").since("1.0");
        Skript.registerEvent("Place", EvtBlock.class, new Class[]{BlockPlaceEvent.class, PlayerBucketEmptyEvent.class, Skript.isRunningMinecraft(1, 4, 3) ? HangingPlaceEvent.class : HangingPlaceEvent.class}, "[block] (plac(e|ing)|build[ing]) [[of] %itemtypes%]").description("Called when a player places a block.").examples("on place", "on place of a furnace, workbench or chest").since("1.0");
        Skript.registerEvent("Fade", EvtBlock.class, BlockFadeEvent.class, "[block] fad(e|ing) [[of] %itemtypes%]").description("Called when a block 'fades away', e.g. ice or snow melts.").examples("on fade of snow or ice").since("1.0");
        Skript.registerEvent("Form", EvtBlock.class, BlockFormEvent.class, "[block] form[ing] [[of] %itemtypes%]").description("Called when a block is created, but not by a player, e.g. snow forms due to snowfall, water freezes in cold biomes. This isn't called when block spreads (mushroom growth, water physics etc.), as it has its own event (see <a href='#spread'>spread event</a>).").examples("on form of snow", "on form of a mushroom").since("1.0");
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        this.types = args[0];
        this.mine = parser.mark == 1;
        return true;
    }

    @Override
    public boolean check(Event e) {
        ItemType item;
        if (this.mine && e instanceof BlockBreakEvent && ((BlockBreakEvent)e).getBlock().getDrops(((BlockBreakEvent)e).getPlayer().getItemInHand()).isEmpty()) {
            return false;
        }
        if (this.types == null) {
            return true;
        }
        if (e instanceof BlockFormEvent) {
            item = new ItemType(((BlockFormEvent)e).getNewState());
        } else if (e instanceof BlockEvent) {
            item = new ItemType(((BlockEvent)e).getBlock());
        } else if (e instanceof PlayerBucketFillEvent) {
            item = new ItemType(((PlayerBucketEvent)e).getBlockClicked().getRelative(((PlayerBucketEvent)e).getBlockFace()));
        } else if (e instanceof PlayerBucketEmptyEvent) {
            item = new ItemType(((PlayerBucketEmptyEvent)e).getBucket());
        } else {
            if (Skript.isRunningMinecraft(1, 4, 3) && e instanceof HangingEvent) {
                final EntityData<Hanging> d = EntityData.fromEntity(((HangingEvent)e).getEntity());
                return this.types.check(e, new Checker<ItemType>(){

                    @Override
                    public boolean check(@Nullable ItemType t) {
                        return t != null && Comparator.Relation.EQUAL.is(DefaultComparators.entityItemComparator.compare(d, t));
                    }
                });
            }
            assert (false);
            return false;
        }
        final ItemType itemF = item;
        return this.types.check(e, new Checker<ItemType>(){

            @Override
            public boolean check(@Nullable ItemType t) {
                return t != null && itemF.isSupertypeOf(t);
            }
        });
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "break/place/burn/fade/form of " + Classes.toString(this.types);
    }
}

