/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Openable;
import org.bukkit.block.data.Powerable;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Toggle")
@Description(value={"Toggle the state of a block."})
@Examples(value={"# use arrows to toggle switches, doors, etc.", "on projectile hit:", "    projectile is arrow", "    toggle the block at the arrow"})
@Since(value="1.4")
public class EffToggle
extends Effect {
    @Nullable
    private static final MethodHandle setDataMethod;
    private static final boolean flattening;
    private Expression<Block> blocks;
    private int toggle;
    private static final byte[] bitFlags;
    private static final boolean[] doors;

    static {
        MethodHandle mh;
        Skript.registerEffect(EffToggle.class, "(close|turn off|de[-]activate) %blocks%", "(toggle|switch) [[the] state of] %blocks%", "(open|turn on|activate) %blocks%");
        flattening = Skript.isRunningMinecraft(1, 13);
        try {
            mh = MethodHandles.lookup().findVirtual(Block.class, "setData", MethodType.methodType(Void.TYPE, Byte.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            mh = null;
        }
        setDataMethod = mh;
        bitFlags = new byte[256];
        doors = new boolean[256];
        EffToggle.bitFlags[28] = 8;
        EffToggle.bitFlags[64] = 4;
        EffToggle.bitFlags[193] = 4;
        EffToggle.bitFlags[194] = 4;
        EffToggle.bitFlags[195] = 4;
        EffToggle.bitFlags[196] = 4;
        EffToggle.bitFlags[197] = 4;
        EffToggle.bitFlags[71] = 4;
        EffToggle.bitFlags[69] = 8;
        EffToggle.bitFlags[70] = 1;
        EffToggle.bitFlags[72] = 1;
        EffToggle.bitFlags[77] = 8;
        EffToggle.bitFlags[96] = 4;
        EffToggle.bitFlags[167] = 4;
        EffToggle.bitFlags[107] = 4;
        EffToggle.bitFlags[183] = 4;
        EffToggle.bitFlags[184] = 4;
        EffToggle.bitFlags[185] = 4;
        EffToggle.bitFlags[186] = 4;
        EffToggle.bitFlags[187] = 4;
        EffToggle.doors[64] = true;
        EffToggle.doors[193] = true;
        EffToggle.doors[194] = true;
        EffToggle.doors[195] = true;
        EffToggle.doors[196] = true;
        EffToggle.doors[197] = true;
        EffToggle.doors[71] = true;
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.blocks = vars[0];
        this.toggle = matchedPattern - 1;
        return true;
    }

    @Override
    protected void execute(Event e) {
        if (!flattening) {
            this.executeLegacy(e);
            return;
        }
        Block[] blockArray = this.blocks.getArray(e);
        int n = blockArray.length;
        int n2 = 0;
        while (n2 < n) {
            Block b = blockArray[n2];
            BlockData data = b.getBlockData();
            if (data instanceof Openable) {
                ((Openable)data).setOpen(!((Openable)data).isOpen());
                b.setBlockData(data);
            } else if (data instanceof Powerable) {
                ((Powerable)data).setPowered(!((Powerable)data).isPowered());
                b.setBlockData(data);
            }
            ++n2;
        }
    }

    private void executeLegacy(Event e) {
        Block[] blockArray = this.blocks.getArray(e);
        int n = blockArray.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                byte data;
                int type;
                Block b;
                block11: {
                    b = blockArray[n2];
                    type = b.getType().getId();
                    data = b.getData();
                    if (!doors[type] || (data & 8) != 8) break block11;
                    type = (b = b.getRelative(BlockFace.DOWN)).getType().getId();
                    if (!doors[type]) break block12;
                    data = b.getData();
                }
                MethodHandle mh = setDataMethod;
                assert (mh != null);
                try {
                    if (this.toggle == -1) {
                        mh.invokeExact(b, (byte)(data & ~bitFlags[type]));
                    } else if (this.toggle == 0) {
                        mh.invokeExact(b, (byte)(data ^ bitFlags[type]));
                    } else {
                        mh.invokeExact(b, (byte)(data | bitFlags[type]));
                    }
                }
                catch (Throwable ex) {
                    Skript.exception(ex, new String[0]);
                }
            }
            ++n2;
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "toggle " + this.blocks.toString(e, debug);
    }
}

