/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.metadata.Metadatable;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Has Metadata")
@Description(value={"Checks whether a metadata holder has a metadata tag."})
@Examples(value={"if player has metadata value \"healer\":"})
@Since(value="2.2-dev36")
public class CondHasMetadata
extends Condition {
    @Nullable
    private Expression<Metadatable> holders;
    @Nullable
    private Expression<String> values;

    static {
        Skript.registerCondition(CondHasMetadata.class, "%metadataholders% (has|have) metadata [(value|tag)[s]] %strings%", "%metadataholders% (doesn't|does not|do not|don't) have metadata [(value|tag)[s]] %strings%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.holders = exprs[0];
        this.values = exprs[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public boolean check(Event e) {
        String[] values = this.values.getArray(e);
        if (values == null || values.length == 0) {
            return false;
        }
        return this.holders.check(e, h -> {
            String[] stringArray2 = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray2[n2];
                if (!h.hasMetadata(value)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }, this.isNegated());
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (!this.isNegated()) {
            return String.valueOf(this.holders.toString(e, debug)) + " has metadata value " + this.values.toString(e, debug);
        }
        return String.valueOf(this.holders.toString(e, debug)) + " does not have metadata value " + this.values.toString(e, debug);
    }
}

