/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.hooks.regions.events;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.hooks.regions.RegionsPlugin;
import ch.njol.skript.hooks.regions.classes.Region;
import ch.njol.skript.hooks.regions.events.RegionBorderEvent;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import ch.njol.util.Checker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

public class EvtRegionBorder
extends SelfRegisteringSkriptEvent {
    private boolean enter;
    @Nullable
    private Literal<Region> regions;
    private static final Collection<Trigger> triggers;
    private static final EventExecutor ee;
    private static boolean registered;

    static {
        Skript.registerEvent("Region Enter/Leave", EvtRegionBorder.class, RegionBorderEvent.class, "(0\u00a6enter[ing]|1\u00a6leav(e|ing)|1\u00a6exit[ing]) [of] ([a] region|[[the] region] %-regions%)", "region (0\u00a6enter[ing]|1\u00a6leav(e|ing)|1\u00a6exit[ing])").description("Called when a player enters or leaves a <a href='../classes.html#region'>region</a>.", "This event requires a supported regions plugin to be installed.").examples("on region exit:", "\tmessage \"Leaving %region%.\"").since("2.1");
        EventValues.registerEventValue(RegionBorderEvent.class, Region.class, new Getter<Region, RegionBorderEvent>(){

            @Override
            public Region get(RegionBorderEvent e) {
                return e.getRegion();
            }
        }, 0);
        EventValues.registerEventValue(RegionBorderEvent.class, Player.class, new Getter<Player, RegionBorderEvent>(){

            @Override
            public Player get(RegionBorderEvent e) {
                return e.getPlayer();
            }
        }, 0);
        triggers = new ArrayList<Trigger>();
        ee = new EventExecutor(){
            @Nullable
            Event last = null;

            public void execute(@Nullable Listener listener, Event event) throws EventException {
                if (event == this.last) {
                    return;
                }
                this.last = event;
                PlayerMoveEvent e = (PlayerMoveEvent)event;
                Location to = e.getTo();
                Location from = e.getFrom();
                if (to != null && to.equals((Object)from)) {
                    return;
                }
                Set<Region> oldRs = RegionsPlugin.getRegionsAt(from);
                Set<Region> newRs = RegionsPlugin.getRegionsAt(to);
                for (Region r : oldRs) {
                    if (newRs.contains(r)) continue;
                    EvtRegionBorder.callEvent(r, e, false);
                }
                for (Region r : newRs) {
                    if (oldRs.contains(r)) continue;
                    EvtRegionBorder.callEvent(r, e, true);
                }
            }
        };
        registered = false;
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.enter = parseResult.mark == 0;
        this.regions = args.length == 0 ? null : args[0];
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        Literal<Region> r = this.regions;
        return String.valueOf(this.enter ? "enter" : "leave") + " of " + (r == null ? "a region" : r.toString(e, debug));
    }

    @Override
    public void register(Trigger t) {
        triggers.add(t);
        EvtRegionBorder.register();
    }

    @Override
    public void unregister(Trigger t) {
        triggers.remove(t);
    }

    @Override
    public void unregisterAll() {
        triggers.clear();
    }

    private boolean applies(Event e) {
        assert (e instanceof RegionBorderEvent);
        if (this.enter != ((RegionBorderEvent)e).isEntering()) {
            return false;
        }
        Literal<Region> r = this.regions;
        if (r == null) {
            return true;
        }
        final Region re = ((RegionBorderEvent)e).getRegion();
        return r.check(e, new Checker<Region>(){

            @Override
            public boolean check(Region r) {
                return r.equals(re);
            }
        });
    }

    static final void callEvent(Region r, PlayerMoveEvent me, boolean enter) {
        Player p = me.getPlayer();
        assert (p != null);
        RegionBorderEvent e = new RegionBorderEvent(r, p, enter);
        e.setCancelled(me.isCancelled());
        for (Trigger t : triggers) {
            if (!((EvtRegionBorder)t.getEvent()).applies(e)) continue;
            t.execute(e);
        }
        me.setCancelled(e.isCancelled());
    }

    private static final void register() {
        if (registered) {
            return;
        }
        Bukkit.getPluginManager().registerEvent(PlayerMoveEvent.class, new Listener(){}, SkriptConfig.defaultEventPriority.value(), ee, (Plugin)Skript.getInstance(), true);
        Bukkit.getPluginManager().registerEvent(PlayerTeleportEvent.class, new Listener(){}, SkriptConfig.defaultEventPriority.value(), ee, (Plugin)Skript.getInstance(), true);
        Bukkit.getPluginManager().registerEvent(PlayerPortalEvent.class, new Listener(){}, SkriptConfig.defaultEventPriority.value(), ee, (Plugin)Skript.getInstance(), true);
        registered = true;
    }
}

