/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Create from XYZ")
@Description(value={"Creates a vector from an x, y and z value"})
@Examples(value={"set {_v} to vector 0, 1, 0"})
@Since(value="2.2-dev28")
public class ExprVectorFromXYZ
extends SimpleExpression<Vector> {
    private Expression<Number> x;
    private Expression<Number> y;
    private Expression<Number> z;

    static {
        Skript.registerExpression(ExprVectorFromXYZ.class, Vector.class, ExpressionType.SIMPLE, "[new] vector [(from|at|to)] %number%,[ ]%number%(,[ ]| and )%number%");
    }

    protected Vector[] get(Event event) {
        Number x = this.x.getSingle(event);
        Number y = this.y.getSingle(event);
        Number z = this.z.getSingle(event);
        if (x == null || y == null || z == null) {
            return null;
        }
        return new Vector[]{new Vector(x.doubleValue(), y.doubleValue(), z.doubleValue())};
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    @Override
    public String toString(@Nullable Event event, boolean b) {
        return "vector from x " + this.x.toString() + ", y " + this.y.toString() + ", z " + this.z.toString();
    }

    @Override
    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.x = expressions[0];
        this.y = expressions[1];
        this.z = expressions[2];
        return true;
    }
}

