/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.Collection;
import java.util.stream.Stream;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Scoreboard Tags")
@Description(value={"Scoreboard tags are simple list of texts stored directly in the data of an <a href='classes.html#entity'>entity</a>.", "So this is a Minecraft related thing, not Bukkit, so the tags will not get removed when the server stops. You can visit <a href='https://minecraft.gamepedia.com/Scoreboard#Tags'>visit Minecraft Wiki</a> for more info.", "This is changeable and valid for any type of entities.Also you can use use the <a href='conditions.html#CondHasScoreboardTag'>Has Scoreboard Tag</a> condition to check whether an entity has the given tags.", "", "Requires Minecraft 1.11+ (actually added in 1.9 to the game, but added in 1.11 to Spigot)."})
@Examples(value={"on spawn of a monster:", "    if the spawn reason is mob spawner:", "        add \"spawned by a spawner\" to the scoreboard tags of event-entity", "", "on death of a monster:", "    if the attacker is a player:", "        if the victim doesn't have the scoreboard tag \"spawned by a spawner\":", "            add 1$ to attacker's balance"})
@Since(value="INSERT VERSION")
public class ExprScoreboardTags
extends SimpleExpression<String> {
    private Expression<Entity> entities;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        boolean bl = $assertionsDisabled = !ExprScoreboardTags.class.desiredAssertionStatus();
        if (Skript.isRunningMinecraft(1, 11)) {
            Skript.registerExpression(ExprScoreboardTags.class, String.class, ExpressionType.PROPERTY, "[(all [[of] the]|the)] scoreboard tags of %entities%", "%entities%'[s] scoreboard tags");
        }
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = exprs[0];
        return true;
    }

    @Nullable
    public String[] get(Event e) {
        return (String[])Stream.of(this.entities.getArray(e)).map(Entity::getScoreboardTags).flatMap(Collection::stream).toArray(String[]::new);
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        switch (mode) {
            case ADD: 
            case SET: 
            case REMOVE: 
            case DELETE: 
            case RESET: {
                return CollectionUtils.array(String[].class);
            }
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Entity[] entityArray = this.entities.getArray(e);
        int n = entityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Entity entity = entityArray[n2];
            switch (mode) {
                case SET: {
                    Object tag;
                    if (!$assertionsDisabled && delta == null) {
                        throw new AssertionError();
                    }
                    entity.getScoreboardTags().clear();
                    Object[] objectArray = delta;
                    int n3 = delta.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        tag = objectArray[n4];
                        entity.addScoreboardTag((String)tag);
                        ++n4;
                    }
                    break;
                }
                case ADD: {
                    Object tag;
                    if (!$assertionsDisabled && delta == null) {
                        throw new AssertionError();
                    }
                    Object[] objectArray = delta;
                    int n3 = delta.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        tag = objectArray[n4];
                        entity.addScoreboardTag((String)tag);
                        ++n4;
                    }
                    break;
                }
                case REMOVE: {
                    Object tag;
                    if (!$assertionsDisabled && delta == null) {
                        throw new AssertionError();
                    }
                    Object[] objectArray = delta;
                    int n3 = delta.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        tag = objectArray[n4];
                        entity.removeScoreboardTag((String)tag);
                        ++n4;
                    }
                    break;
                }
                case DELETE: 
                case RESET: {
                    entity.getScoreboardTags().clear();
                }
            }
            ++n2;
        }
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the scoreboard tags of " + this.entities.toString(e, debug);
    }
}

