/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import java.net.InetSocketAddress;
import org.bukkit.entity.Player;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Player IP")
@Description(value={"The IP address of a player.", "", "Note: you may use the '<a href='expressions.html#ExprIP'>IP</a>' expression for getting the IP in a <a href='events.html#connect>connect</a> event."})
@Examples(value={"ban IP of the player"})
@Since(value="1.4")
public class ExprPlayerIP
extends SimplePropertyExpression<Player, String> {
    static {
        ExprPlayerIP.register(ExprPlayerIP.class, String.class, "IP[(-| )address[es]]", "players");
    }

    @Override
    @Nullable
    public String convert(Player player) {
        InetSocketAddress address = player.getAddress();
        return address == null ? "unknown" : address.getAddress().toString();
    }

    @Override
    protected String getPropertyName() {
        return "IP-address";
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }
}

