/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Open/Close Inventory")
@Description(value={"Opens an inventory to a player. The player can then access and modify the inventory as if it was a chest that he just opened.", "Please note that currently 'show' and 'open' have the same effect, but 'show' will eventually show an unmodifiable view of the inventory in the future."})
@Examples(value={"show the victim's inventory to the player", "open the player's inventory for the player"})
@Since(value="2.0, 2.1.1 (closing), 2.2-Fixes-V10 (anvil)")
public class EffOpenInventory
extends Effect {
    private static final int WORKBENCH = 0;
    private static final int CHEST = 1;
    private static final int ANVIL = 2;
    @Nullable
    private Expression<Inventory> invi;
    boolean open;
    private int invType;
    private Expression<Player> players;

    static {
        Skript.registerEffect(EffOpenInventory.class, "(0\u00a6open|1\u00a6show) ((20\u00a6(crafting [table]|workbench)|40\u00a6chest|60\u00a6anvil) (view|window|inventory|)|%-inventory%) (to|for) %players%", "close [the] inventory [view] (to|of|for) %players%", "close %players%'[s] inventory [view]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        int openFlag = 0;
        if (parseResult.mark >= 60) {
            openFlag = parseResult.mark ^ 0x3C;
            this.invType = 2;
        } else if (parseResult.mark >= 40) {
            openFlag = parseResult.mark ^ 0x28;
            this.invType = 1;
        } else if (parseResult.mark >= 20) {
            this.invType = 0;
            openFlag = parseResult.mark ^ 0x14;
        } else {
            openFlag = parseResult.mark;
        }
        this.open = matchedPattern == 0;
        this.invi = this.open ? exprs[0] : null;
        this.players = exprs[exprs.length - 1];
        if (openFlag == 1 && this.invi != null) {
            Skript.warning("Using 'show' inventory instead of 'open' is not recommended as it will eventually show an unmodifiable view of the inventory in the future.");
        }
        return true;
    }

    @Override
    protected void execute(Event e) {
        if (this.invi != null) {
            Inventory i = this.invi.getSingle(e);
            if (i == null) {
                return;
            }
            Player[] playerArray = this.players.getArray(e);
            int n = playerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Player p = playerArray[n2];
                try {
                    p.openInventory(i);
                }
                catch (IllegalArgumentException ex) {
                    Skript.error("You can't open a " + i.getType().name().toLowerCase().replaceAll("_", "") + " inventory to a player.");
                }
                ++n2;
            }
        } else {
            Player[] playerArray = this.players.getArray(e);
            int n = playerArray.length;
            int n3 = 0;
            while (n3 < n) {
                Player p = playerArray[n3];
                if (this.open) {
                    switch (this.invType) {
                        case 0: {
                            p.openWorkbench(null, true);
                            break;
                        }
                        case 1: {
                            p.openInventory(Bukkit.createInventory((InventoryHolder)p, (InventoryType)InventoryType.CHEST));
                            break;
                        }
                        case 2: {
                            p.openInventory(Bukkit.createInventory((InventoryHolder)p, (InventoryType)InventoryType.ANVIL));
                        }
                    }
                } else {
                    p.closeInventory();
                }
                ++n3;
            }
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.open ? "open " + (this.invi != null ? this.invi.toString(e, debug) : "crafting table") + " to " : "close inventory view of ") + this.players.toString(e, debug);
    }
}

